/// <reference path="./internal_*.d.ts" />
declare namespace net.fabricmc.fabric.mixin.transfer {
    interface BucketItemAccessor {
        abstract fabric_getFluid(): Internal.Fluid;
        (): Internal.Fluid_;
    }
    type BucketItemAccessor_ = BucketItemAccessor;
}
declare namespace Internal {
    class BlockSourceImpl implements Internal.BlockSource {
        constructor($$0: Internal.ServerLevel_, $$1: BlockPos_)
        z(): number;
        getPos(): BlockPos;
        getLevel(): Internal.ServerLevel;
        getEntity<T extends Internal.BlockEntity>(): T;
        getBlockState(): Internal.BlockState;
        y(): number;
        x(): number;
        get pos(): BlockPos
        get level(): Internal.ServerLevel
        get entity(): T
        get blockState(): Internal.BlockState
    }
    type BlockSourceImpl_ = BlockSourceImpl;
    class ThrowablePotionItem extends Internal.PotionItem {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ThrowablePotionItem_ = ThrowablePotionItem;
    class BookTemplate {
        constructor()
        static createTemplate(book: Internal.Book_, builder: Internal.BookContentsBuilder_, type: string, inclusion: Internal.TemplateInclusion_): Internal.BookTemplate;
        render(graphics: Internal.GuiGraphics_, page: Internal.BookPage_, mouseX: number, mouseY: number, pticks: number): void;
        onDisplayed(page: Internal.BookPage_, parent: Internal.GuiBookEntry_, left: number, top: number): void;
        build(builder: Internal.BookContentsBuilder_, page: Internal.BookPage_, entry: Internal.BookEntry_, pageNum: number): void;
        static registerComponent(name: ResourceLocation_, clazz: typeof Internal.TemplateComponent): void;
        compile(level: Internal.Level_, builder: Internal.BookContentsBuilder_, variables: Internal.IVariableProvider_): void;
        mouseClicked(page: Internal.BookPage_, mouseX: number, mouseY: number, mouseButton: number): boolean;
        static readonly componentTypes: {[key: ResourceLocation]: typeof any, [key: ResourceLocation]: typeof any, [key: ResourceLocation]: typeof any, [key: ResourceLocation]: typeof any, [key: ResourceLocation]: typeof any, [key: ResourceLocation]: typeof any, [key: ResourceLocation]: typeof any, [key: ResourceLocation]: typeof any, [key: ResourceLocation]: typeof any};
    }
    type BookTemplate_ = BookTemplate;
    abstract class PropertyValue <T extends Internal.PropertyValue<T, J>, J> extends Internal.AbstractProperty<T> {
        constructor()
        constructor(value: J)
        abstract serializeValue(): Internal.JsonElement;
        static addValueTransformer<T extends Internal.PropertyValue<T, J>, J>(clazz: J, constructor_: Internal.Function_<J, Internal.PropertyValue<T, J>>): void;
        static init(): void;
        getValue(): J;
        abstract deserializeValue(arg0: Internal.JsonElement_): J;
        get value(): J
        static VALUES_REGISTRY: {[key: typeof any]: any, [key: typeof any]: any, [key: typeof any]: any, [key: typeof any]: any, [key: typeof any]: any, [key: typeof any]: any, [key: typeof any]: any};
    }
    type PropertyValue_<T extends Internal.PropertyValue<T, J>, J> = PropertyValue<T, J>;
    class WeightedEntry$Wrapper <T> implements Internal.WeightedEntry {
        static codec<E>($$0: Internal.Codec_<E>): Internal.Codec<Internal.WeightedEntry$Wrapper<E>>;
        getWeight(): Internal.Weight;
        getData(): T;
        static wrap<T>($$0: T, $$1: number): Internal.WeightedEntry$Wrapper<T>;
        get weight(): Internal.Weight
        get data(): T
    }
    type WeightedEntry$Wrapper_<T> = WeightedEntry$Wrapper<T>;
    interface Version extends Internal.Comparable<Internal.Version> {
        abstract compareTo(arg0: Internal.Version_): number;
        parse(arg0: string): this;
        abstract getFriendlyString(): string;
        get friendlyString(): string
    }
    type Version_ = Version;
    class RootCommandNode <S> extends Internal.CommandNode<S> {
        constructor()
        isValidInput(arg0: string): boolean;
        createBuilder(): Internal.ArgumentBuilder<S, any>;
    }
    type RootCommandNode_<S> = RootCommandNode<S>;
    class LayerPattern$Layer$Builder {
        constructor()
        blocks(block: Internal.Block_, deepblock: Internal.Block_): this;
        block(block: Internal.Block_): this;
        build(): Internal.LayerPattern$Layer;
        size(min: number, max: number): this;
        block(block: Internal.NonNullSupplier_<Internal.Block>): this;
        passiveBlock(): this;
        blocks(blocksByDepth: Internal.Couple_<Internal.NonNullSupplier<Internal.Block>>): this;
        weight(weight: number): this;
    }
    type LayerPattern$Layer$Builder_ = LayerPattern$Layer$Builder;
    interface BooleanConsumer {
        abstract accept(arg0: boolean): void;
        (arg0: boolean): void;
    }
    type BooleanConsumer_ = BooleanConsumer;
    class SelectedPart {
        constructor()
        constructor(facade: Internal.IFacadePart_, side: Internal.Direction_)
        constructor(part: Internal.IPart_, side: Internal.Direction_)
        readonly side: Internal.Direction;
        readonly facade: Internal.IFacadePart;
        readonly part: Internal.IPart;
    }
    type SelectedPart_ = SelectedPart;
    class WaterlilyBlock extends Internal.BushBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type WaterlilyBlock_ = WaterlilyBlock;
    class FogType extends Internal.Enum<Internal.FogType> {
        static values(): Internal.FogType[];
        static valueOf($$0: string): Internal.FogType;
        static readonly LAVA: Internal.FogType;
        static readonly POWDER_SNOW: Internal.FogType;
        static readonly WATER: Internal.FogType;
        static readonly NONE: Internal.FogType;
    }
    type FogType_ = "powder_snow" | "lava" | FogType | "water" | "none";
    interface IExtendedNoiseGeneratorSettings {
        abstract setRegionType(arg0: Internal.RegionType_): void;
        abstract getRegionType(): Internal.RegionType;
        set regionType(arg0: Internal.RegionType_)
        get regionType(): Internal.RegionType
    }
    type IExtendedNoiseGeneratorSettings_ = IExtendedNoiseGeneratorSettings;
    class BottleItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        handler$eom001$milk$use(world: Internal.Level_, user: Internal.Player_, hand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BottleItem_ = BottleItem;
    class RopeBlock extends Internal.IronBarsBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly TIED_TO_BELL: Internal.BooleanProperty;
    }
    type RopeBlock_ = RopeBlock;
    interface Blaze3dRenderTargetExt {
        abstract iris$getColorBufferVersion(): number;
        abstract iris$getDepthBufferVersion(): number;
    }
    type Blaze3dRenderTargetExt_ = Blaze3dRenderTargetExt;
    interface Scriptable extends Internal.IdEnumerationIterator {
        abstract get(arg0: Internal.Context_, arg1: string, arg2: Internal.Scriptable_): any;
        abstract getPrototype(arg0: Internal.Context_): this;
        abstract getParentScope(): this;
        abstract hasInstance(arg0: Internal.Context_, arg1: Internal.Scriptable_): boolean;
        abstract get(arg0: Internal.Context_, arg1: number, arg2: Internal.Scriptable_): any;
        abstract put(arg0: Internal.Context_, arg1: number, arg2: Internal.Scriptable_, arg3: any): void;
        abstract getClassName(): string;
        getAllIds(cx: Internal.Context_): any[];
        abstract "delete"(arg0: Internal.Context_, arg1: string): void;
        enumerationIteratorHasNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        abstract "delete"(arg0: Internal.Context_, arg1: number): void;
        abstract setParentScope(arg0: Internal.Scriptable_): void;
        abstract has(arg0: Internal.Context_, arg1: string, arg2: Internal.Scriptable_): boolean;
        enumerationIteratorNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        abstract getDefaultValue(arg0: Internal.Context_, arg1: typeof any): any;
        abstract has(arg0: Internal.Context_, arg1: number, arg2: Internal.Scriptable_): boolean;
        abstract setPrototype(arg0: Internal.Scriptable_): void;
        getTypeOf(): Internal.MemberType;
        abstract put(arg0: Internal.Context_, arg1: string, arg2: Internal.Scriptable_, arg3: any): void;
        abstract getIds(arg0: Internal.Context_): any[];
        get parentScope(): Internal.Scriptable
        get className(): string
        set parentScope(arg0: Internal.Scriptable_)
        set prototype(arg0: Internal.Scriptable_)
        get typeOf(): Internal.MemberType
        readonly NOT_FOUND: Internal.UniqueTag;
    }
    type Scriptable_ = Scriptable;
    class ItemGorgonHead extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemGorgonHead_ = ItemGorgonHead;
    class ArmAngleTarget {
        constructor(armPos: BlockPos_, pointTarget: Vec3d_, clawFacing: Internal.Direction_, ceiling: boolean)
    }
    type ArmAngleTarget_ = ArmAngleTarget;
    class ItemVaultBlock extends Internal.Block implements Internal.IBE<Internal.ItemVaultBlockEntity>, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.CustomSoundTypeBlock {
        constructor(p_i48440_1_: Internal.BlockBehaviour$Properties_)
        static getVaultBlockAxis(state: Internal.BlockState_): Internal.Direction$Axis;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ItemVaultBlockEntity>): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static isVault(state: Internal.BlockState_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ItemVaultBlockEntity;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntityClass(): typeof Internal.ItemVaultBlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ItemVaultBlockEntity>;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ItemVaultBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getSoundType(state: Internal.BlockState_, world: Internal.LevelReader_, pos: BlockPos_, entity: Internal.Entity_): SoundType;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        static isLarge(state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        getBlockEntityType(): Internal.BlockEntityType<Internal.ItemVaultBlockEntity>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.ItemVaultBlockEntity
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.ItemVaultBlockEntity>
        static readonly HORIZONTAL_AXIS: Internal.Property<Internal.Direction$Axis>;
        static readonly LARGE: Internal.BooleanProperty;
        static readonly SILENCED_METAL: SoundType;
    }
    type ItemVaultBlock_ = ItemVaultBlock;
    abstract class AbstractRegistrate <S extends Internal.AbstractRegistrate<S>> {
        defaultCreativeTab(creativeModeTab: Internal.ResourceKey_<Internal.CreativeModeTab>): S;
        menu<T extends Internal.AbstractContainerMenu, SC extends Internal.Screen & Internal.MenuAccess<T>, P>(parent: P, name: string, factory: Internal.MenuBuilder$ForgeMenuFactory_<T>, screenFactory: Internal.NonNullSupplier_<Internal.MenuBuilder$ScreenFactory<T, SC>>): Internal.MenuBuilder<T, SC, P>;
        getModid(): string;
        enchantment<T extends Internal.Enchantment, P>(parent: P, name: string, type: Internal.EnchantmentCategory_, factory: Internal.EnchantmentBuilder$EnchantmentFactory_<T>): com.tterrag.registrate.builders.EnchantmentBuilder<T, P>;
        block<T extends Internal.Block, P>(parent: P, name: string, factory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.BlockBehaviour$Properties, T>): com.tterrag.registrate.builders.BlockBuilder<T, P>;
        defaultCreativeTab(): Internal.NoConfigBuilder<Internal.CreativeModeTab, Internal.CreativeModeTab, S>;
        modifyCreativeModeTab(creativeModeTab: Internal.ResourceKey_<Internal.CreativeModeTab>, modifier: Internal.Consumer_<Internal.CreativeModeTabModifier>): S;
        defaultCreativeTab<P>(parent: P): Internal.NoConfigBuilder<Internal.CreativeModeTab, Internal.CreativeModeTab, P>;
        makeRegistry<R>(builder: Internal.FabricRegistryBuilder_<R, any>): Internal.ResourceKey<Internal.Registry<R>>;
        fluid<P>(parent: P): com.tterrag.registrate.builders.FluidBuilder<com.tterrag.registrate.fabric.SimpleFlowableFluid$Flowing, P>;
        fluid(): com.tterrag.registrate.builders.FluidBuilder<com.tterrag.registrate.fabric.SimpleFlowableFluid$Flowing, S>;
        entity<T extends Internal.Entity>(factory: Internal.EntityType$EntityFactory_<T>, classification: Internal.MobCategory_): Internal.EntityBuilder<T, S>;
        enchantment<T extends Internal.Enchantment>(type: Internal.EnchantmentCategory_, factory: Internal.EnchantmentBuilder$EnchantmentFactory_<T>): com.tterrag.registrate.builders.EnchantmentBuilder<T, S>;
        getAll<R>(type: Internal.ResourceKey_<Internal.Registry<R>>): Internal.Collection<Internal.RegistryEntry<R>>;
        addRawLang(key: string, value: string): Internal.MutableComponent;
        blockEntity<T extends Internal.BlockEntity>(name: string, factory: Internal.BlockEntityBuilder$BlockEntityFactory_<T>): Internal.BlockEntityBuilder<T, S>;
        item<T extends Internal.Item, P>(parent: P, factory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.Item$Properties, T>): com.tterrag.registrate.builders.ItemBuilder<T, P>;
        blockEntity<T extends Internal.BlockEntity>(factory: Internal.BlockEntityBuilder$BlockEntityFactory_<T>): Internal.BlockEntityBuilder<T, S>;
        simple<R, T extends R>(name: string, registryType: Internal.ResourceKey_<Internal.Registry<R>>, factory: Internal.NonNullSupplier_<T>): Internal.RegistryEntry<T>;
        defaultCreativeTab<P>(parent: P, config: Internal.Consumer_<Internal.CreativeModeTab$Builder>): Internal.NoConfigBuilder<Internal.CreativeModeTab, Internal.CreativeModeTab, P>;
        setDataGenerator<P extends Internal.RegistrateProvider, R>(entry: string, registryType: Internal.ResourceKey_<Internal.Registry<R>>, type: Internal.ProviderType_<P>, cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<P>): S;
        enchantment<T extends Internal.Enchantment, P>(parent: P, type: Internal.EnchantmentCategory_, factory: Internal.EnchantmentBuilder$EnchantmentFactory_<T>): com.tterrag.registrate.builders.EnchantmentBuilder<T, P>;
        makeRegistry<R>(name: string, ...attributes: Internal.RegistryAttribute_[]): Internal.ResourceKey<Internal.Registry<R>>;
        item<T extends Internal.Item, P>(parent: P, name: string, factory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.Item$Properties, T>): com.tterrag.registrate.builders.ItemBuilder<T, P>;
        simple<R, T extends R, P>(parent: P, registryType: Internal.ResourceKey_<Internal.Registry<R>>, factory: Internal.NonNullSupplier_<T>): Internal.RegistryEntry<T>;
        addRegisterCallback<R>(registryType: Internal.ResourceKey_<Internal.Registry<R>>, callback: Internal.Runnable_): S;
        blockEntity<T extends Internal.BlockEntity, P>(parent: P, factory: Internal.BlockEntityBuilder$BlockEntityFactory_<T>): Internal.BlockEntityBuilder<T, P>;
        object(name: string): S;
        menu<T extends Internal.AbstractContainerMenu, SC extends Internal.Screen & Internal.MenuAccess<T>>(name: string, factory: Internal.MenuBuilder$ForgeMenuFactory_<T>, screenFactory: Internal.NonNullSupplier_<Internal.MenuBuilder$ScreenFactory<T, SC>>): Internal.MenuBuilder<T, SC, S>;
        generic<R, T extends R, P>(parent: P, registryType: Internal.ResourceKey_<Internal.Registry<R>>, factory: Internal.NonNullSupplier_<T>): Internal.NoConfigBuilder<R, T, P>;
        entity<T extends Internal.Entity, P>(parent: P, name: string, factory: Internal.EntityType$EntityFactory_<T>, classification: Internal.MobCategory_): Internal.EntityBuilder<T, P>;
        block<T extends Internal.Block>(factory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.BlockBehaviour$Properties, T>): com.tterrag.registrate.builders.BlockBuilder<T, S>;
        setupDatagen(pack: Internal.FabricDataGenerator$Pack_, existingFileHelper: Internal.ExistingFileHelper_): void;
        addLang(type: string, id: ResourceLocation_, suffix: string, localizedName: string): Internal.MutableComponent;
        skipErrors(skipErrors: boolean): S;
        makeRegistry<R>(name: string, defaultId: ResourceLocation_): Internal.ResourceKey<Internal.Registry<R>>;
        menu<T extends Internal.AbstractContainerMenu, SC extends Internal.Screen & Internal.MenuAccess<T>, P>(parent: P, name: string, factory: Internal.MenuBuilder$MenuFactory_<T>, screenFactory: Internal.NonNullSupplier_<Internal.MenuBuilder$ScreenFactory<T, SC>>): Internal.MenuBuilder<T, SC, P>;
        isRegistered<R>(registryType: Internal.ResourceKey_<Internal.Registry<R>>): boolean;
        getOptional<R, T extends R>(name: string, type: Internal.ResourceKey_<Internal.Registry<R>>): Internal.RegistryEntry<T>;
        block<T extends Internal.Block>(name: string, factory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.BlockBehaviour$Properties, T>): com.tterrag.registrate.builders.BlockBuilder<T, S>;
        menu<T extends Internal.AbstractContainerMenu, SC extends Internal.Screen & Internal.MenuAccess<T>>(factory: Internal.MenuBuilder$ForgeMenuFactory_<T>, screenFactory: Internal.NonNullSupplier_<Internal.MenuBuilder$ScreenFactory<T, SC>>): Internal.MenuBuilder<T, SC, S>;
        menu<T extends Internal.AbstractContainerMenu, SC extends Internal.Screen & Internal.MenuAccess<T>, P>(parent: P, factory: Internal.MenuBuilder$MenuFactory_<T>, screenFactory: Internal.NonNullSupplier_<Internal.MenuBuilder$ScreenFactory<T, SC>>): Internal.MenuBuilder<T, SC, P>;
        addLang(type: string, id: ResourceLocation_, localizedName: string): Internal.MutableComponent;
        entry<R, T extends R, P, S2 extends Internal.Builder<R, T, P, S2>>(factory: Internal.NonNullBiFunction_<string, Internal.BuilderCallback, S2>): S2;
        fluid<T extends com.tterrag.registrate.fabric.SimpleFlowableFluid>(name: string, stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_, fluidFactory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.SimpleFlowableFluid$Properties, T>): com.tterrag.registrate.builders.FluidBuilder<T, S>;
        item<T extends Internal.Item>(factory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.Item$Properties, T>): com.tterrag.registrate.builders.ItemBuilder<T, S>;
        transform<R, T extends R, P, S2 extends Internal.Builder<R, T, P, S2>>(func: com.tterrag.registrate.util.nullness.NonNullFunction_<S, S2>): S2;
        generic<R, T extends R, P>(parent: P, name: string, registryType: Internal.ResourceKey_<Internal.Registry<R>>, factory: Internal.NonNullSupplier_<T>): Internal.NoConfigBuilder<R, T, P>;
        static isDevEnvironment(): boolean;
        simple<R, T extends R, P>(parent: P, name: string, registryType: Internal.ResourceKey_<Internal.Registry<R>>, factory: Internal.NonNullSupplier_<T>): Internal.RegistryEntry<T>;
        fluid<P>(parent: P, stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_): com.tterrag.registrate.builders.FluidBuilder<com.tterrag.registrate.fabric.SimpleFlowableFluid$Flowing, P>;
        fluid<P>(parent: P, name: string): com.tterrag.registrate.builders.FluidBuilder<com.tterrag.registrate.fabric.SimpleFlowableFluid$Flowing, P>;
        transform(func: Internal.NonNullUnaryOperator_<S>): S;
        setDataGenerator<P extends Internal.RegistrateProvider, R>(builder: Internal.Builder_<R, any, any, any>, type: Internal.ProviderType_<P>, cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<P>): S;
        fluid<P>(parent: P, name: string, stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_): com.tterrag.registrate.builders.FluidBuilder<com.tterrag.registrate.fabric.SimpleFlowableFluid$Flowing, P>;
        fluid<T extends com.tterrag.registrate.fabric.SimpleFlowableFluid, P>(parent: P, name: string, stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_, fluidFactory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.SimpleFlowableFluid$Properties, T>): com.tterrag.registrate.builders.FluidBuilder<T, P>;
        blockEntity<T extends Internal.BlockEntity, P>(parent: P, name: string, factory: Internal.BlockEntityBuilder$BlockEntityFactory_<T>): Internal.BlockEntityBuilder<T, P>;
        addRegisterCallback<R, T extends R>(name: string, registryType: Internal.ResourceKey_<Internal.Registry<R>>, callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): S;
        register(): void;
        defaultCreativeTab(name: string): Internal.NoConfigBuilder<Internal.CreativeModeTab, Internal.CreativeModeTab, S>;
        simple<R, T extends R>(registryType: Internal.ResourceKey_<Internal.Registry<R>>, factory: Internal.NonNullSupplier_<T>): Internal.RegistryEntry<T>;
        item<T extends Internal.Item>(name: string, factory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.Item$Properties, T>): com.tterrag.registrate.builders.ItemBuilder<T, S>;
        makeRegistry<R>(name: string, defaultId: ResourceLocation_, ...attributes: Internal.RegistryAttribute_[]): Internal.ResourceKey<Internal.Registry<R>>;
        entity<T extends Internal.Entity>(name: string, factory: Internal.EntityType$EntityFactory_<T>, classification: Internal.MobCategory_): Internal.EntityBuilder<T, S>;
        entity<T extends Internal.Entity, P>(parent: P, factory: Internal.EntityType$EntityFactory_<T>, classification: Internal.MobCategory_): Internal.EntityBuilder<T, P>;
        enchantment<T extends Internal.Enchantment>(name: string, type: Internal.EnchantmentCategory_, factory: Internal.EnchantmentBuilder$EnchantmentFactory_<T>): com.tterrag.registrate.builders.EnchantmentBuilder<T, S>;
        defaultCreativeTab<P>(parent: P, name: string, config: Internal.Consumer_<Internal.CreativeModeTab$Builder>): Internal.NoConfigBuilder<Internal.CreativeModeTab, Internal.CreativeModeTab, P>;
        fluid<T extends com.tterrag.registrate.fabric.SimpleFlowableFluid>(stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_, fluidFactory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.SimpleFlowableFluid$Properties, T>): com.tterrag.registrate.builders.FluidBuilder<T, S>;
        get<R, T extends R>(name: string, type: Internal.ResourceKey_<Internal.Registry<R>>): Internal.RegistryEntry<T>;
        makeRegistry<R>(name: string, defaultName: string): Internal.ResourceKey<Internal.Registry<R>>;
        menu<T extends Internal.AbstractContainerMenu, SC extends Internal.Screen & Internal.MenuAccess<T>>(factory: Internal.MenuBuilder$MenuFactory_<T>, screenFactory: Internal.NonNullSupplier_<Internal.MenuBuilder$ScreenFactory<T, SC>>): Internal.MenuBuilder<T, SC, S>;
        defaultCreativeTab(name: string, config: Internal.Consumer_<Internal.CreativeModeTab$Builder>): Internal.NoConfigBuilder<Internal.CreativeModeTab, Internal.CreativeModeTab, S>;
        fluid(stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_): com.tterrag.registrate.builders.FluidBuilder<com.tterrag.registrate.fabric.SimpleFlowableFluid$Flowing, S>;
        fluid<T extends com.tterrag.registrate.fabric.SimpleFlowableFluid, P>(parent: P, stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_, fluidFactory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.SimpleFlowableFluid$Properties, T>): com.tterrag.registrate.builders.FluidBuilder<T, P>;
        fluid(name: string, stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_): com.tterrag.registrate.builders.FluidBuilder<com.tterrag.registrate.fabric.SimpleFlowableFluid$Flowing, S>;
        defaultCreativeTab<P>(parent: P, name: string): Internal.NoConfigBuilder<Internal.CreativeModeTab, Internal.CreativeModeTab, P>;
        get<R, T extends R>(type: Internal.ResourceKey_<Internal.Registry<R>>): Internal.RegistryEntry<T>;
        getDataProvider<P extends Internal.RegistrateProvider>(type: Internal.ProviderType_<P>): Internal.Optional<P>;
        defaultCreativeTab(config: Internal.Consumer_<Internal.CreativeModeTab$Builder>): Internal.NoConfigBuilder<Internal.CreativeModeTab, Internal.CreativeModeTab, S>;
        genData<T extends Internal.RegistrateProvider>(type: Internal.ProviderType_<T>, gen: T): void;
        makeRegistry<R>(name: string): Internal.ResourceKey<Internal.Registry<R>>;
        menu<T extends Internal.AbstractContainerMenu, SC extends Internal.Screen & Internal.MenuAccess<T>, P>(parent: P, factory: Internal.MenuBuilder$ForgeMenuFactory_<T>, screenFactory: Internal.NonNullSupplier_<Internal.MenuBuilder$ScreenFactory<T, SC>>): Internal.MenuBuilder<T, SC, P>;
        block<T extends Internal.Block, P>(parent: P, factory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.BlockBehaviour$Properties, T>): com.tterrag.registrate.builders.BlockBuilder<T, P>;
        generic<R, T extends R>(name: string, registryType: Internal.ResourceKey_<Internal.Registry<R>>, factory: Internal.NonNullSupplier_<T>): Internal.NoConfigBuilder<R, T, S>;
        addDataGenerator<T extends Internal.RegistrateProvider>(type: Internal.ProviderType_<T>, cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): S;
        fluid(name: string): com.tterrag.registrate.builders.FluidBuilder<com.tterrag.registrate.fabric.SimpleFlowableFluid$Flowing, S>;
        generic<R, T extends R>(registryType: Internal.ResourceKey_<Internal.Registry<R>>, factory: Internal.NonNullSupplier_<T>): Internal.NoConfigBuilder<R, T, S>;
        entry<R, T extends R, P, S2 extends Internal.Builder<R, T, P, S2>>(name: string, factory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.BuilderCallback, S2>): S2;
        menu<T extends Internal.AbstractContainerMenu, SC extends Internal.Screen & Internal.MenuAccess<T>>(name: string, factory: Internal.MenuBuilder$MenuFactory_<T>, screenFactory: Internal.NonNullSupplier_<Internal.MenuBuilder$ScreenFactory<T, SC>>): Internal.MenuBuilder<T, SC, S>;
        get modid(): string
        get devEnvironment(): boolean
    }
    type AbstractRegistrate_<S extends Internal.AbstractRegistrate<S>> = AbstractRegistrate<S>;
    class NarrationThunk <T> {
        getText($$0: Internal.Consumer_<string>): void;
        static from($$0: string): Internal.NarrationThunk<any>;
        static from($$0: net.minecraft.network.chat.Component_): Internal.NarrationThunk<any>;
        static from($$0: Internal.List_<net.minecraft.network.chat.Component>): Internal.NarrationThunk<any>;
        static readonly EMPTY: Internal.NarrationThunk<any>;
    }
    type NarrationThunk_<T> = NarrationThunk<T>;
    class JsonArray extends Internal.JsonElement implements Internal.Iterable<Internal.JsonElement> {
        constructor()
        constructor(arg0: number)
        iterator(): Internal.Iterator<Internal.JsonElement>;
        asList(): Internal.List<Internal.JsonElement>;
        add(arg0: Internal.JsonElement_): void;
        remove(arg0: number): Internal.JsonElement;
        spliterator(): Internal.Spliterator<Internal.JsonElement>;
        add(arg0: string): void;
        isEmpty(): boolean;
        add(arg0: number): void;
        set(arg0: number, arg1: Internal.JsonElement_): Internal.JsonElement;
        forEach(arg0: Internal.Consumer_<Internal.JsonElement>): void;
        contains(arg0: Internal.JsonElement_): boolean;
        remove(arg0: Internal.JsonElement_): boolean;
        size(): number;
        addAll(arg0: Internal.JsonArray_): void;
        get(arg0: number): Internal.JsonElement;
        add(arg0: string): void;
        add(arg0: boolean): void;
        get empty(): boolean
    }
    type JsonArray_ = JsonArray;
    class SekhmetSpecialHandler$Factory implements Internal.SpecialHandler$Factory<Internal.SekhmetSpecialHandler> {
        constructor()
        tryMatch(pattern: Internal.HexPattern_, env: Internal.CastingEnvironment_): Internal.SekhmetSpecialHandler;
    }
    type SekhmetSpecialHandler$Factory_ = SekhmetSpecialHandler$Factory;
    class DeadBushBlock extends Internal.BushBlock implements Internal.IShearable {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type DeadBushBlock_ = DeadBushBlock;
    class LivingEntityEvents$ChangeTarget$ChangeTargetEvent$LivingTargetType extends Internal.Enum<Internal.LivingEntityEvents$ChangeTarget$ChangeTargetEvent$LivingTargetType> {
        static valueOf(name: string): Internal.LivingEntityEvents$ChangeTarget$ChangeTargetEvent$LivingTargetType;
        static values(): Internal.LivingEntityEvents$ChangeTarget$ChangeTargetEvent$LivingTargetType[];
        static readonly MOB_TARGET: Internal.LivingEntityEvents$ChangeTarget$ChangeTargetEvent$LivingTargetType;
        static readonly BEHAVIOR_TARGET: Internal.LivingEntityEvents$ChangeTarget$ChangeTargetEvent$LivingTargetType;
    }
    type LivingEntityEvents$ChangeTarget$ChangeTargetEvent$LivingTargetType_ = "behavior_target" | "mob_target" | LivingEntityEvents$ChangeTarget$ChangeTargetEvent$LivingTargetType;
    class AllArmInteractionPointTypes$SawType extends Internal.ArmInteractionPointType {
        constructor()
    }
    type AllArmInteractionPointTypes$SawType_ = AllArmInteractionPointTypes$SawType;
    abstract class CrateBlockEntity extends Internal.SmartBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
    }
    type CrateBlockEntity_ = CrateBlockEntity;
    interface ServerPlayerAccessor {
        abstract invokeInitMenu(arg0: Internal.AbstractContainerMenu_): void;
        abstract invokeNextContainerCounter(): void;
        abstract getContainerCounter(): number;
        get containerCounter(): number
    }
    type ServerPlayerAccessor_ = ServerPlayerAccessor;
    interface MenuProvider extends Internal.NamedScreenHandlerFactoryMixin, Internal.FabricScreenHandlerFactory, Internal.MenuConstructor {
        abstract getDisplayName(): net.minecraft.network.chat.Component;
        shouldCloseCurrentScreen(): boolean;
        abstract createMenu(arg0: number, arg1: Internal.Inventory_, arg2: Internal.Player_): Internal.AbstractContainerMenu;
        get displayName(): net.minecraft.network.chat.Component
    }
    type MenuProvider_ = MenuProvider;
    class IafDragonAttacks$Air extends Internal.Enum<Internal.IafDragonAttacks$Air> {
        static valueOf(name: string): Internal.IafDragonAttacks$Air;
        static values(): Internal.IafDragonAttacks$Air[];
        static readonly HOVER_BLAST: Internal.IafDragonAttacks$Air;
        static readonly SCORCH_STREAM: Internal.IafDragonAttacks$Air;
        static readonly TACKLE: Internal.IafDragonAttacks$Air;
    }
    type IafDragonAttacks$Air_ = "tackle" | "hover_blast" | "scorch_stream" | IafDragonAttacks$Air;
    class ShapedRecipe implements Internal.AccessorShapedRecipe, Internal.ShapedRecipeAccessor, Internal.CraftingRecipe {
        constructor($$0: ResourceLocation_, $$1: string, $$2: Internal.CraftingBookCategory_, $$3: number, $$4: number, $$5: Internal.NonNullList_<Internal.Ingredient>, $$6: Internal.ItemStack_)
        constructor($$0: ResourceLocation_, $$1: string, $$2: Internal.CraftingBookCategory_, $$3: number, $$4: number, $$5: Internal.NonNullList_<Internal.Ingredient>, $$6: Internal.ItemStack_, $$7: boolean)
        static keyFromJson($$0: Internal.JsonObject_): Internal.Map<string, Internal.Ingredient>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        matches($$0: Internal.CraftingContainer_, $$1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        static patternFromJson$bookshelf_$md$fca01f$2(arg0: Internal.JsonArray_): string[];
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        assemble($$0: Internal.CraftingContainer_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        category(): Internal.CraftingBookCategory;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        static bookshelf$shrink(...pattern: string[]): string[];
        getId(): ResourceLocation;
        static bookshelf$keyFromJson($$0: Internal.JsonObject_): Internal.Map<string, Internal.Ingredient>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getHeight(): number;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        static bookshelf$dissolvePattern(pattern: string[], ingredients: Internal.Map_<string, Internal.Ingredient>, width: number, height: number): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem($$0: Internal.RegistryAccess_): Internal.ItemStack;
        static dissolvePattern$bookshelf_$md$fca01f$3(arg0: string[], arg1: Internal.Map_<any, any>, arg2: number, arg3: number): Internal.NonNullList<any>;
        getWidth(): number;
        canCraftInDimensions($$0: number, $$1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        static keyFromJson$bookshelf_$md$fca01f$0(arg0: Internal.JsonObject_): Internal.Map<any, any>;
        static itemStackFromJson($$0: Internal.JsonObject_): Internal.ItemStack;
        getType(): ResourceLocation;
        static patternFromJson($$0: Internal.JsonArray_): string[];
        static dissolvePattern($$0: string[], $$1: Internal.Map_<string, Internal.Ingredient>, $$2: number, $$3: number): Internal.NonNullList<Internal.Ingredient>;
        static shrink(...$$0: string[]): string[];
        static shrink$bookshelf_$md$fca01f$1(...arg0: string[]): string[];
        setGroup(group: string): void;
        getResult(): Internal.ItemStack;
        static itemFromJson($$0: Internal.JsonObject_): Internal.Item;
        static bookshelf$patternFromJson(json: Internal.JsonArray_): string[];
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        matches($$0: Internal.CraftingContainer_, $$1: number, $$2: number, $$3: boolean): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get height(): number
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get width(): number
        get type(): ResourceLocation
        set group(group: string)
        get result(): Internal.ItemStack
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        readonly width: number;
        readonly height: number;
        readonly result: Internal.ItemStack;
    }
    type ShapedRecipe_ = ShapedRecipe;
    class CreativeEnergyBlock extends Internal.CrateBlock implements Internal.IBE<Internal.CreativeEnergyBlockEntity> {
        constructor(props: Internal.BlockBehaviour$Properties_)
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CreativeEnergyBlockEntity>;
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.CreativeEnergyBlockEntity>;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CreativeEnergyBlockEntity;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CreativeEnergyBlockEntity>): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CreativeEnergyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockEntityClass(): typeof Internal.CreativeEnergyBlockEntity;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.CreativeEnergyBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.CreativeEnergyBlockEntity
        static readonly CREATIVE_ENERGY_SHAPE: Internal.ArrayVoxelShape;
    }
    type CreativeEnergyBlock_ = CreativeEnergyBlock;
    class FeatureSizeType <P extends Internal.FeatureSize> {
        codec(): Internal.Codec<P>;
        static readonly THREE_LAYERS_FEATURE_SIZE: Internal.FeatureSizeType<Internal.ThreeLayersFeatureSize>;
        static readonly TWO_LAYERS_FEATURE_SIZE: Internal.FeatureSizeType<Internal.TwoLayersFeatureSize>;
    }
    type FeatureSizeType_<P extends Internal.FeatureSize> = FeatureSizeType<P> | Special.FeatureSizeType;
    class LootDataType <T> {
        static values(): Internal.Stream<Internal.LootDataType<any>>;
        runValidation($$0: Internal.ValidationContext_, $$1: Internal.LootDataId_<T>, $$2: T): void;
        deserialize($$0: ResourceLocation_, $$1: Internal.JsonElement_): Internal.Optional<T>;
        directory(): string;
        parser(): Internal.Gson;
        static readonly MODIFIER: Internal.LootDataType<Internal.LootItemFunction>;
        static readonly PREDICATE: Internal.LootDataType<Internal.LootItemCondition>;
        static readonly TABLE: Internal.LootDataType<Internal.LootTable>;
    }
    type LootDataType_<T> = LootDataType<T>;
    interface DynamicLightSource {
        abstract splitIntoDynamicLightEntries(arg0: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        abstract getDynamicLightChunksToRebuild(arg0: boolean): Internal.LongSet;
    }
    type DynamicLightSource_ = DynamicLightSource;
    interface ITurtleAccess {
        abstract playAnimation(arg0: Internal.TurtleAnimation_): void;
        abstract isFuelNeeded(): boolean;
        abstract teleportTo(arg0: Internal.Level_, arg1: BlockPos_): boolean;
        abstract getPosition(): BlockPos;
        abstract getFuelLimit(): number;
        abstract setFuelLevel(arg0: number): void;
        abstract executeCommand(arg0: Internal.TurtleCommand_): Internal.MethodResult;
        abstract getLevel(): Internal.Level;
        abstract getInventory(): net.minecraft.world.Container;
        abstract isRemoved(): boolean;
        abstract getOwningPlayer(): Internal.GameProfile;
        abstract setColour(arg0: number): void;
        getUpgradeWithData(side: Internal.TurtleSide_): dan200.computercraft.api.upgrades.UpgradeData<Internal.ITurtleUpgrade>;
        abstract getUpgrade(arg0: Internal.TurtleSide_): Internal.ITurtleUpgrade;
        abstract updateUpgradeNBTData(arg0: Internal.TurtleSide_): void;
        /**
         * @deprecated
        */
        setUpgrade(side: Internal.TurtleSide_, upgrade: Internal.ITurtleUpgrade_): void;
        abstract getSelectedSlot(): number;
        abstract getFuelLevel(): number;
        abstract getColour(): number;
        abstract getUpgradeNBTData(arg0: Internal.TurtleSide_): Internal.CompoundTag;
        abstract setSelectedSlot(arg0: number): void;
        abstract setDirection(arg0: Internal.Direction_): void;
        abstract addFuel(arg0: number): void;
        abstract getPeripheral(arg0: Internal.TurtleSide_): Internal.IPeripheral;
        abstract consumeFuel(arg0: number): boolean;
        abstract setUpgradeWithData(arg0: Internal.TurtleSide_, arg1: dan200.computercraft.api.upgrades.UpgradeData_<Internal.ITurtleUpgrade>): void;
        abstract getDirection(): Internal.Direction;
        get fuelNeeded(): boolean
        get position(): BlockPos
        get fuelLimit(): number
        set fuelLevel(arg0: number)
        get level(): Internal.Level
        get inventory(): net.minecraft.world.Container
        get removed(): boolean
        get owningPlayer(): Internal.GameProfile
        set colour(arg0: number)
        get selectedSlot(): number
        get fuelLevel(): number
        get colour(): number
        set selectedSlot(arg0: number)
        set direction(arg0: Internal.Direction_)
        get direction(): Internal.Direction
    }
    type ITurtleAccess_ = ITurtleAccess;
    class BannerBlock extends Internal.AbstractBannerBlock {
        constructor($$0: Internal.DyeColor_, $$1: Internal.BlockBehaviour$Properties_)
        static byColor($$0: Internal.DyeColor_): Internal.Block;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly ROTATION: Internal.IntegerProperty;
    }
    type BannerBlock_ = BannerBlock;
    interface TeamPropertyCollection {
        abstract read(arg0: Internal.FriendlyByteBuf_): void;
        abstract copy(): this;
        abstract write(arg0: Internal.FriendlyByteBuf_): void;
        abstract forEach<T>(arg0: Internal.BiConsumer_<Internal.TeamProperty<T>, Internal.TeamPropertyValue<T>>): void;
        abstract get<T>(arg0: Internal.TeamProperty_<T>): T;
        abstract updateFrom(arg0: Internal.TeamPropertyCollection_): void;
        abstract set<T>(arg0: Internal.TeamProperty_<T>, arg1: T): void;
    }
    type TeamPropertyCollection_ = TeamPropertyCollection;
    class CastingImage$ParenthesizedIota$Companion {
        constructor($constructor_marker: any_)
    }
    type CastingImage$ParenthesizedIota$Companion_ = CastingImage$ParenthesizedIota$Companion;
    interface Callable <V> {
        abstract call(): V;
        (): V;
    }
    type Callable_<V> = Callable<V>;
    class FenceBlock extends Internal.CrossCollisionBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        connectsTo($$0: Internal.BlockState_, $$1: boolean, $$2: Internal.Direction_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type FenceBlock_ = FenceBlock;
    class ValveHandleBlock extends Internal.HandCrankBlock {
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.HandCrankBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static copper(properties: Internal.BlockBehaviour$Properties_): Internal.ValveHandleBlock;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        clicked(level: Internal.Level_, pos: BlockPos_, blockState: Internal.BlockState_, player: Internal.Player_, hand: Internal.InteractionHand_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        static onBlockActivated(player: Internal.Player_, level: Internal.Level_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.HandCrankBlockEntity>): void;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.HandCrankBlockEntity>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.HandCrankBlockEntity;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        static dyed(properties: Internal.BlockBehaviour$Properties_, color: Internal.DyeColor_): Internal.ValveHandleBlock;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        showCapacityWithAnnotation(): boolean;
        emi(amount: number): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        readonly color: Internal.DyeColor;
    }
    type ValveHandleBlock_ = ValveHandleBlock;
    class ArrayList <E> extends Internal.AbstractList<E> implements Internal.RandomAccess, Internal.Cloneable, Internal.List<E>, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.Collection_<E>)
        constructor(arg0: number)
        clone(): any;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        get(arg0: number): E;
        getLast(): E;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        listIterator(): Internal.ListIterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        set(arg0: number, arg1: E): E;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        remove(arg0: number): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        subList(arg0: number, arg1: number): Internal.List<E>;
        trimToSize(): void;
        toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        getFirst(): E;
        listIterator(arg0: number): Internal.ListIterator<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        stream(): Internal.Stream<E>;
        ensureCapacity(arg0: number): void;
        spliterator(): Internal.Spliterator<E>;
        removeLast(): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        get last(): E
        get first(): E
    }
    type ArrayList_<E> = ArrayList<E>;
    interface NonNullConsumer <T> extends Internal.Consumer<T> {
        andThen(arg0: Internal.Consumer_<T>): Internal.Consumer<T>;
        noop<T>(): this;
        andThen(after: Internal.NonNullConsumer_<T>): this;
        abstract accept(arg0: T): void;
        (arg0: T): void;
    }
    type NonNullConsumer_<T> = NonNullConsumer<T>;
    interface LootParams$DynamicDrop {
        abstract add(arg0: Internal.Consumer_<Internal.ItemStack>): void;
        (arg0: Internal.Consumer<Internal.ItemStack>): void;
    }
    type LootParams$DynamicDrop_ = LootParams$DynamicDrop;
    class HandCrankBlock extends Internal.DirectionalKineticBlock implements Internal.ProperWaterloggedBlock, Internal.IBE<Internal.HandCrankBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntityClass(): typeof Internal.HandCrankBlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.HandCrankBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.HandCrankBlockEntity>): void;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.HandCrankBlockEntity>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.HandCrankBlockEntity;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        getRotationSpeed(): number;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        showCapacityWithAnnotation(): boolean;
        emi(amount: number): Internal.EmiStack;
        getBlockEntityType(): Internal.BlockEntityType<Internal.HandCrankBlockEntity>;
        get blockEntityClass(): typeof Internal.HandCrankBlockEntity
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get rotationSpeed(): number
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.HandCrankBlockEntity>
    }
    type HandCrankBlock_ = HandCrankBlock;
    class BacktankItem$BacktankBlockItem extends Internal.BlockItem {
        constructor(block: Internal.Block_, actualItem: Internal.Supplier_<Internal.Item>, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getActualItem(): Internal.Item;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get actualItem(): Internal.Item
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BacktankItem$BacktankBlockItem_ = BacktankItem$BacktankBlockItem;
    interface SpectatorMenuListener {
        abstract onSpectatorMenuClosed(arg0: Internal.SpectatorMenu_): void;
        (arg0: Internal.SpectatorMenu): void;
    }
    type SpectatorMenuListener_ = SpectatorMenuListener;
    class SimpleMountedStorageType$Impl extends Internal.SimpleMountedStorageType<any> {
        constructor()
        mount(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.MountedItemStorage;
    }
    type SimpleMountedStorageType$Impl_ = SimpleMountedStorageType$Impl;
    class ItemCountDisplaySource extends Internal.NumericSingleLineDisplaySource {
        constructor()
    }
    type ItemCountDisplaySource_ = ItemCountDisplaySource;
    class CharmOfSinkingItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        static shouldSink(entity: Internal.LivingEntity_): boolean;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CharmOfSinkingItem_ = CharmOfSinkingItem;
    class Painting extends Internal.HangingEntity implements Internal.PaintingAccessor, Internal.VariantHolder<Internal.Holder<Internal.PaintingVariant>> {
        constructor($$0: Internal.EntityType_<Internal.Painting>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.Direction_, $$3: Internal.Holder_<Internal.PaintingVariant>)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        static create($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.Direction_): Internal.Optional<Internal.Painting>;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        static storeVariant($$0: Internal.CompoundTag_, $$1: Internal.Holder_<Internal.PaintingVariant>): void;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        getVariant(): Internal.Holder<Internal.PaintingVariant>;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        static loadVariant($$0: Internal.CompoundTag_): Internal.Optional<Internal.Holder<Internal.PaintingVariant>>;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setVariant($$0: Internal.Holder_<Internal.PaintingVariant>): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getVariant(): any;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        porting_lib$setVariant(arg0: Internal.Holder_<any>): void;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        setVariant(arg0: any): void;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get variant(): Internal.Holder<Internal.PaintingVariant>
        get server(): Internal.MinecraftServer
        set variant($$0: Internal.Holder_<Internal.PaintingVariant>)
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get variant(): any
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        set variant(arg0: any)
        static readonly VARIANT_TAG: "variant";
    }
    type Painting_ = Painting;
    class FluidValveBlock extends Internal.DirectionalAxisKineticBlock implements Internal.ProperWaterloggedBlock, Internal.IBE<Internal.FluidValveBlockEntity>, Internal.IAxisPipe {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getAxis(state: Internal.BlockState_): Internal.Direction$Axis;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        static isOpenAt(state: Internal.BlockState_, d: Internal.Direction_): boolean;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static getPipeAxis(state: Internal.BlockState_): Internal.Direction$Axis;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityClass(): typeof Internal.FluidValveBlockEntity;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FluidValveBlockEntity>): void;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FluidValveBlockEntity;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FluidValveBlockEntity>;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBlockEntityType(): Internal.BlockEntityType<Internal.FluidValveBlockEntity>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static getAxisOf(state: Internal.BlockState_): Internal.Direction$Axis;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        showCapacityWithAnnotation(): boolean;
        emi(amount: number): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FluidValveBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.FluidValveBlockEntity
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityType(): Internal.BlockEntityType<Internal.FluidValveBlockEntity>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly ENABLED: Internal.BooleanProperty;
    }
    type FluidValveBlock_ = FluidValveBlock;
    class NoiseColumn implements Internal.BlockColumn {
        constructor($$0: number, $$1: Internal.BlockState_[])
        getBlock($$0: number): Internal.BlockState;
        setBlock($$0: number, $$1: Internal.BlockState_): void;
    }
    type NoiseColumn_ = NoiseColumn;
    interface Boolean2ReferenceFunction <V> extends it.unimi.dsi.fastutil.Function<boolean, V> {
        put(arg0: boolean, arg1: V): V;
        andThenInt(arg0: Internal.Reference2IntFunction_<V>): Internal.Boolean2IntFunction;
        composeShort(arg0: Internal.Short2BooleanFunction_): Internal.Short2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        andThenFloat(arg0: Internal.Reference2FloatFunction_<V>): Internal.Boolean2FloatFunction;
        composeInt(arg0: Internal.Int2BooleanFunction_): Internal.Int2ReferenceFunction<V>;
        composeObject<T>(arg0: Internal.Object2BooleanFunction_<T>): Internal.Object2ReferenceFunction<T, V>;
        composeChar(arg0: Internal.Char2BooleanFunction_): Internal.Char2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeByte(arg0: Internal.Byte2BooleanFunction_): Internal.Byte2ReferenceFunction<V>;
        composeFloat(arg0: Internal.Float2BooleanFunction_): Internal.Float2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        put(arg0: boolean, arg1: V): V;
        andThenObject<T>(arg0: Internal.Reference2ObjectFunction_<V, T>): Internal.Boolean2ObjectFunction<T>;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenShort(arg0: Internal.Reference2ShortFunction_<V>): Internal.Boolean2ShortFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        andThenDouble(arg0: Internal.Reference2DoubleFunction_<V>): Internal.Boolean2DoubleFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, boolean>): Internal.Function<T, V>;
        andThenChar(arg0: Internal.Reference2CharFunction_<V>): Internal.Boolean2CharFunction;
        apply(arg0: boolean): V;
        abstract get(arg0: boolean): V;
        composeDouble(arg0: Internal.Double2BooleanFunction_): Internal.Double2ReferenceFunction<V>;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<boolean, V>;
        composeReference<T>(arg0: Internal.Reference2BooleanFunction_<T>): Internal.Reference2ReferenceFunction<T, V>;
        containsKey(arg0: boolean): boolean;
        remove(arg0: boolean): V;
        size(): number;
        andThenLong(arg0: Internal.Reference2LongFunction_<V>): Internal.Boolean2LongFunction;
        andThenByte(arg0: Internal.Reference2ByteFunction_<V>): Internal.Boolean2ByteFunction;
        andThenReference<T>(arg0: Internal.Reference2ReferenceFunction_<V, T>): Internal.Boolean2ReferenceFunction<T>;
        clear(): void;
        composeLong(arg0: Internal.Long2BooleanFunction_): Internal.Long2ReferenceFunction<V>;
        defaultReturnValue(): V;
        getOrDefault(arg0: boolean, arg1: V): V;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        (arg0: boolean): V;
    }
    type Boolean2ReferenceFunction_<V> = Boolean2ReferenceFunction<V>;
    abstract class AbstractSimiWidget extends Internal.AbstractWidget implements Internal.TickableGuiEventListener {
        charTyped($$0: string, $$1: number): boolean;
        static of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        setActive<T extends Internal.AbstractSimiWidget>(active: boolean): T;
        intersects(other: Internal.PositionedRectangle_): boolean;
        withCallback<T extends Internal.AbstractSimiWidget>(cb: Internal.BiConsumer_<number, number>): T;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        runCallback(mouseX: number, mouseY: number): void;
        moveTo(x: number, y: number): void;
        remove(): void;
        isInBoundingBox(x: number, y: number): boolean;
        hasParent(): boolean;
        fullSize(): Internal.Size;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        getToolTip(): Internal.List<net.minecraft.network.chat.Component>;
        mouseMoved($$0: number, $$1: number): void;
        tooltip(tooltip: Internal.Collection_<net.minecraft.network.chat.Component>): io.wispforest.owo.ui.core.Component;
        atZLevel<T extends Internal.AbstractSimiWidget>(z: number): T;
        setPosition($$0: number, $$1: number): void;
        method_47399(pNarrationElementOutput: Internal.NarrationElementOutput_): void;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        tick(): void;
        keyPressed($$0: number, $$1: number, $$2: number): boolean;
        static of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        getCurrentFocusPath(): Internal.ComponentPath;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        withCallback<T extends Internal.AbstractSimiWidget>(cb: Internal.Runnable_): T;
        setHeight(value: number): void;
        root(): Internal.ParentComponent;
        tooltip(tooltip: net.minecraft.network.chat.Component_): io.wispforest.owo.ui.core.Component;
        set active(active: boolean)
        get toolTip(): Internal.List<net.minecraft.network.chat.Component>
        get currentFocusPath(): Internal.ComponentPath
        set height(value: number)
        static readonly COLOR_SUCCESS: Internal.Couple<net.createmod.catnip.theme.Color>;
        lockedTooltipY: number;
        static readonly COLOR_DISABLED: Internal.Couple<net.createmod.catnip.theme.Color>;
        static readonly COLOR_HOVER: Internal.Couple<net.createmod.catnip.theme.Color>;
        static readonly HEADER_RGB: net.createmod.catnip.theme.Color;
        static readonly HINT_RGB: net.createmod.catnip.theme.Color;
        static readonly COLOR_FAIL: Internal.Couple<net.createmod.catnip.theme.Color>;
        static readonly COLOR_CLICK: Internal.Couple<net.createmod.catnip.theme.Color>;
        static readonly COLOR_IDLE: Internal.Couple<net.createmod.catnip.theme.Color>;
        lockedTooltipX: number;
    }
    type AbstractSimiWidget_ = AbstractSimiWidget;
    class PoweredShaftBlockEntity extends Internal.GeneratingKineticBlockEntity {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        canBePoweredBy(globalPos: BlockPos_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        isPoweredBy(globalPos: BlockPos_): boolean;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        update(sourcePos: BlockPos_, direction: number, efficiency: number): void;
        addToEngineTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        remove(sourcePos: BlockPos_): void;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        engineEfficiency: number;
        movementDirection: number;
        capacityKey: Internal.Block;
        enginePos: BlockPos;
        initialTicks: number;
    }
    type PoweredShaftBlockEntity_ = PoweredShaftBlockEntity;
    interface LocalPlayerInterface {
        abstract getCurrentConstantMood(): number;
        get currentConstantMood(): number
        (): number;
    }
    type LocalPlayerInterface_ = LocalPlayerInterface;
    class PosAlwaysTrueTest extends Internal.PosRuleTest {
        static readonly INSTANCE: Internal.PosAlwaysTrueTest;
        static readonly CODEC: Internal.Codec<Internal.PosAlwaysTrueTest>;
    }
    type PosAlwaysTrueTest_ = PosAlwaysTrueTest;
    interface DensityFunction$SimpleFunction extends Internal.DensityFunction {
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        abstract maxValue(): number;
        abstract codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        abstract compute(arg0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        square(): Internal.DensityFunction;
        mapAll($$0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp($$0: number, $$1: number): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        cube(): Internal.DensityFunction;
        fillArray($$0: number[], $$1: Internal.DensityFunction$ContextProvider_): void;
        abstract minValue(): number;
    }
    type DensityFunction$SimpleFunction_ = DensityFunction$SimpleFunction;
    class BlockEntityDragonForge extends Internal.BaseContainerBlockEntity implements Internal.WorldlyContainer {
        constructor(pos: BlockPos_, state: Internal.BlockState_)
        constructor(pos: BlockPos_, state: Internal.BlockState_, fireType: number)
        stopOpen($$0: Internal.Player_): void;
        static tryClear($$0: any): void;
        grillMatches(block: Internal.Block_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        method_11007(compound: Internal.CompoundTag_): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        getMaxCookTime(): number;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        setChanged(): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getSlotsForFace(side: Internal.Direction_): number[];
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        static tick(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, entityDragonforge: Internal.BlockEntityDragonForge_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        toUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        asComponentProvider(): Internal.ComponentProvider;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getCurrentRecipe(): Internal.Optional<Internal.DragonForgeRecipe>;
        canTakeItemThroughFace(index: number, stack: Internal.ItemStack_, direction: Internal.Direction_): boolean;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        isBurning(): boolean;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        getTypeID(): string;
        startOpen($$0: Internal.Player_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        transferPower(i: number): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        canPlaceItemThroughFace(index: number, itemStackIn: Internal.ItemStack_, direction: Internal.Direction_): boolean;
        getUpdatePacket(): Internal.Packet<any>;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        getGrillBlock(): Internal.Block;
        shouldCloseCurrentScreen(): boolean;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        smeltItem(): void;
        canReceiveTransferCooldown(): boolean;
        getRecipes(): Internal.List<Internal.DragonForgeRecipe>;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        getPropertyDelegate(): Internal.DragonForgePropertyDelegate;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        assembled(): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        canSmelt(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        getFireType(block: Internal.Block_): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get maxCookTime(): number
        get slots(): number
        get width(): number
        get currentRecipe(): Internal.Optional<Internal.DragonForgeRecipe>
        get burning(): boolean
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get typeID(): string
        get updatePacket(): Internal.Packet<any>
        get grillBlock(): Internal.Block
        get recipes(): Internal.List<Internal.DragonForgeRecipe>
        get height(): number
        get propertyDelegate(): Internal.DragonForgePropertyDelegate
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        lastDragonFlameTimer: number;
    }
    type BlockEntityDragonForge_ = BlockEntityDragonForge;
    interface Boolean2ByteFunction extends it.unimi.dsi.fastutil.Function<boolean, number> {
        composeFloat(arg0: Internal.Float2BooleanFunction_): Internal.Float2ByteFunction;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Boolean2DoubleFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        remove(arg0: boolean): number;
        composeDouble(arg0: Internal.Double2BooleanFunction_): Internal.Double2ByteFunction;
        composeByte(arg0: Internal.Byte2BooleanFunction_): Internal.Byte2ByteFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, boolean>): Internal.Function<T, number>;
        composeObject<T>(arg0: Internal.Object2BooleanFunction_<T>): Internal.Object2ByteFunction<T>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        defaultReturnValue(arg0: number): void;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Boolean2ShortFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        composeChar(arg0: Internal.Char2BooleanFunction_): Internal.Char2ByteFunction;
        composeInt(arg0: Internal.Int2BooleanFunction_): Internal.Int2ByteFunction;
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Boolean2IntFunction;
        andThenByte(arg0: Internal.Byte2ByteFunction_): this;
        composeLong(arg0: Internal.Long2BooleanFunction_): Internal.Long2ByteFunction;
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Boolean2LongFunction;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Boolean2FloatFunction;
        abstract get(arg0: boolean): number;
        apply(arg0: boolean): number;
        containsKey(arg0: boolean): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Boolean2ObjectFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: boolean, arg1: number): number;
        getOrDefault(arg0: boolean, arg1: number): number;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Boolean2CharFunction;
        size(): number;
        put(arg0: boolean, arg1: number): number;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Boolean2ReferenceFunction<T>;
        clear(): void;
        composeShort(arg0: Internal.Short2BooleanFunction_): Internal.Short2ByteFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<boolean, T>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        composeReference<T>(arg0: Internal.Reference2BooleanFunction_<T>): Internal.Reference2ByteFunction<T>;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        (arg0: boolean): number;
    }
    type Boolean2ByteFunction_ = Boolean2ByteFunction;
    class SignedMessageLink extends Internal.Record {
        constructor($$0: number, $$1: Internal.UUID_, $$2: Internal.UUID_)
        advance(): this;
        static unsigned($$0: Internal.UUID_): Internal.SignedMessageLink;
        static root($$0: Internal.UUID_, $$1: Internal.UUID_): Internal.SignedMessageLink;
        index(): number;
        isDescendantOf($$0: Internal.SignedMessageLink_): boolean;
        sessionId(): Internal.UUID;
        updateSignature($$0: Internal.SignatureUpdater$Output_): void;
        sender(): Internal.UUID;
        static readonly CODEC: Internal.Codec<Internal.SignedMessageLink>;
    }
    type SignedMessageLink_ = SignedMessageLink;
    class ClientboundChangeDifficultyPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Difficulty_, $$1: boolean)
        isLocked(): boolean;
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getDifficulty(): Internal.Difficulty;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get locked(): boolean
        get difficulty(): Internal.Difficulty
        get skippable(): boolean
    }
    type ClientboundChangeDifficultyPacket_ = ClientboundChangeDifficultyPacket;
    class Train implements Internal.IBufferBlockedTrain, Internal.IOccupiedCouplers, Internal.AccessorTrain, Internal.ICrashAdvancement, Internal.IHandcarTrain, Internal.IStrictSignalTrain, Internal.IIndexedSchedule {
        constructor(id: Internal.UUID_, owner: Internal.UUID_, graph: Internal.TrackGraph_, carriages: Internal.List_<Internal.Carriage>, carriageSpacing: Internal.List_<number>, doubleEnded: boolean)
        railways$setIndex(index: number): void;
        setCurrentStation(station: Internal.GlobalStation_): void;
        getNavigationPenalty(): number;
        hasBackwardConductor(): boolean;
        cancelStall(): void;
        railways$getBlockedSign(): number;
        getPresentDimensions(): Internal.List<Internal.ResourceKey<Internal.Level>>;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        hasForwardConductor(): boolean;
        collectInitiallyOccupiedSignalBlocks(): void;
        isTravellingOn(node: Internal.TrackNode_): boolean;
        frontSignalListener(): Internal.TravellingPoint$IEdgePointListener;
        disassemble(assemblyDirection: Internal.Direction_, pos: BlockPos_): boolean;
        railways$setStrictSignals(strictSignals: boolean): void;
        getOwner(level: Internal.Level_): Internal.LivingEntity;
        reattachToTracks(level: Internal.Level_): void;
        tick(level: Internal.Level_): void;
        railways$setHandcar(handcar: boolean): void;
        acceleration(): number;
        approachTargetSpeed(accelerationMod: number): void;
        railways$setStress(arg0: number[]): void;
        distanceToLocationSqr(level: Internal.Level_, location: Vec3d_): number;
        forEachTravellingPoint(callback: Internal.Consumer_<Internal.TravellingPoint>): void;
        determineHonk(level: Internal.Level_): void;
        handler$gmo000$railways$maxSpeed(cir: Internal.CallbackInfoReturnable_<any>): void;
        maxTurnSpeed(): number;
        getTotalLength(): number;
        shouldCarriageSyncThisTick(gameTicks: number, updateInterval: number): boolean;
        arriveAt(station: Internal.GlobalStation_): void;
        crash(): void;
        countPlayerPassengers(): number;
        railways$getOccupiedCouplers(): Internal.Set<any>;
        railways$setControlBlocked(controlBlocked: boolean, forceBackwards: boolean): void;
        earlyTick(level: Internal.Level_): void;
        detachFromTracks(): void;
        getEndpointEdges(): Internal.Couple<Internal.Couple<Internal.TrackNode>>;
        railways$isControlBlocked(): boolean;
        railways$getStress(): number[];
        railways$awardCrashAdvancements(): void;
        forEachTravellingPointBackwards(callback: Internal.BiConsumer_<Internal.TravellingPoint, number>): void;
        findCollidingTrain(level: Internal.Level_, start: Vec3d_, end: Vec3d_, dimension: Internal.ResourceKey_<Internal.Level>): net.createmod.catnip.data.Pair<Internal.Train, Vec3d>;
        maxSpeed(): number;
        backSignalListener(): Internal.TravellingPoint$IEdgePointListener;
        getPositionInDimension(dimension: Internal.ResourceKey_<Internal.Level>): Internal.Optional<BlockPos>;
        handler$gmo000$railways$acceleration(cir: Internal.CallbackInfoReturnable_<any>): void;
        burnFuel(): void;
        canDisassemble(): boolean;
        handler$gmo000$railways$maxTurnSpeed(cir: Internal.CallbackInfoReturnable_<any>): void;
        railways$isHandcar(): boolean;
        static read(tag: Internal.CompoundTag_, trackNetworks: Internal.Map_<Internal.UUID, Internal.TrackGraph>, dimensions: Internal.DimensionPalette_): Internal.Train;
        getCurrentStation(): Internal.GlobalStation;
        railways$getIndex(): number;
        leaveStation(): void;
        set currentStation(station: Internal.GlobalStation_)
        get navigationPenalty(): number
        get presentDimensions(): Internal.List<Internal.ResourceKey<Internal.Level>>
        get totalLength(): number
        get endpointEdges(): Internal.Couple<Internal.Couple<Internal.TrackNode>>
        get currentStation(): Internal.GlobalStation
        railways$occupiedCouplers: Internal.Set<any>;
        navigation: Internal.Navigation;
        doubleEnded: boolean;
        speed: number;
        honk: boolean;
        manualSteer: Internal.TravellingPoint$SteerDirection;
        occupiedObservers: Internal.Set<Internal.UUID>;
        mapColorIndex: number;
        updateSignalBlocks: boolean;
        carriageWaitingForChunks: number;
        status: Internal.TrainStatus;
        carriages: Internal.List<Internal.Carriage>;
        migrationCooldown: number;
        manualTick: boolean;
        graph: Internal.TrackGraph;
        icon: Internal.TrainIconType;
        derailed: boolean;
        cachedObserverFiltering: Internal.Map<Internal.UUID, net.createmod.catnip.data.Pair<number, boolean>>;
        lowHonk: boolean;
        currentlyBackwards: boolean;
        speedBeforeStall: number;
        honkTicks: number;
        id: Internal.UUID;
        owner: Internal.UUID;
        honkPitch: number;
        currentStation: Internal.UUID;
        name: net.minecraft.network.chat.Component;
        invalid: boolean;
        occupiedSignalBlocks: Internal.Map<Internal.UUID, Internal.UUID>;
        reservedSignalBlocks: Internal.Set<Internal.UUID>;
        accumulatedSteamRelease: number;
        throttle: number;
        targetSpeed: number;
        carriageSpacing: Internal.List<number>;
        backwardsDriver: Internal.Player;
        runtime: Internal.ScheduleRuntime;
        fuelTicks: number;
    }
    type Train_ = Train;
    class SlotRange extends Internal.Record {
        constructor(firstSlot: number, numberOfSlots: number)
        firstSlot(): number;
        isInRange(slotIndex: number): boolean;
        numberOfSlots(): number;
    }
    type SlotRange_ = SlotRange;
    class Layer <S extends Internal.Screen, R extends Internal.ParentComponent> {
        instantiate(screen: S): Internal.Layer$Instance<>;
        getInstance(screen: S): Internal.Layer$Instance<>;
    }
    type Layer_<S extends Internal.Screen, R extends Internal.ParentComponent> = Layer<S, R>;
    class HangingSignBlockEntity extends Internal.SignBlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
    }
    type HangingSignBlockEntity_ = HangingSignBlockEntity;
    class AmbientAdditionsSettings {
        constructor($$0: Internal.Holder_<Internal.SoundEvent>, $$1: number)
        getTickChance(): number;
        getSoundEvent(): Internal.Holder<Internal.SoundEvent>;
        get tickChance(): number
        get soundEvent(): Internal.Holder<Internal.SoundEvent>
        static readonly CODEC: Internal.Codec<Internal.AmbientAdditionsSettings>;
    }
    type AmbientAdditionsSettings_ = AmbientAdditionsSettings;
    class ClientboundExplodePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.List_<BlockPos>, $$5: Vec3d_)
        getX(): number;
        handle(arg0: Internal.PacketListener_): void;
        getToBlow(): Internal.List<BlockPos>;
        getY(): number;
        getZ(): number;
        write($$0: Internal.FriendlyByteBuf_): void;
        getPower(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getKnockbackZ(): number;
        isSkippable(): boolean;
        getKnockbackX(): number;
        getKnockbackY(): number;
        get x(): number
        get toBlow(): Internal.List<BlockPos>
        get y(): number
        get z(): number
        get power(): number
        get knockbackZ(): number
        get skippable(): boolean
        get knockbackX(): number
        get knockbackY(): number
    }
    type ClientboundExplodePacket_ = ClientboundExplodePacket;
    class IntegerArgumentInfo implements Internal.ArgumentTypeInfo<Internal.IntegerArgumentType, Internal.IntegerArgumentInfo$Template> {
        constructor()
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        serializeToJson($$0: Internal.IntegerArgumentInfo$Template_, $$1: Internal.JsonObject_): void;
        deserializeFromNetwork($$0: Internal.FriendlyByteBuf_): Internal.IntegerArgumentInfo$Template;
        serializeToNetwork($$0: Internal.IntegerArgumentInfo$Template_, $$1: Internal.FriendlyByteBuf_): void;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        unpack($$0: Internal.IntegerArgumentType_): Internal.IntegerArgumentInfo$Template;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
    }
    type IntegerArgumentInfo_ = IntegerArgumentInfo;
    interface ImageObserver {
        abstract imageUpdate(arg0: Internal.Image_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
        (arg0: Internal.Image, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
        readonly SOMEBITS: 8;
        readonly ALLBITS: 32;
        readonly WIDTH: 1;
        readonly PROPERTIES: 4;
        readonly ABORT: 128;
        readonly FRAMEBITS: 16;
        readonly HEIGHT: 2;
        readonly ERROR: 64;
    }
    type ImageObserver_ = ImageObserver;
    interface IBufferBlockedTrain {
        abstract railways$setControlBlocked(arg0: boolean, arg1: boolean): void;
        abstract railways$isControlBlocked(): boolean;
        abstract railways$getBlockedSign(): number;
    }
    type IBufferBlockedTrain_ = IBufferBlockedTrain;
    interface FriendlyByteBuf$Writer <T> extends Internal.BiConsumer<Internal.FriendlyByteBuf, T> {
        andThen(arg0: Internal.BiConsumer_<Internal.FriendlyByteBuf, T>): Internal.BiConsumer<Internal.FriendlyByteBuf, T>;
        abstract accept(arg0: Internal.FriendlyByteBuf_, arg1: T): void;
        asOptional(): Internal.FriendlyByteBuf$Writer<Internal.Optional<T>>;
        (arg0: Internal.FriendlyByteBuf, arg1: T): void;
    }
    type FriendlyByteBuf$Writer_<T> = FriendlyByteBuf$Writer<T>;
    class FrameForEach implements Internal.ContinuationFrame {
        constructor(data: Internal.SpellList_, code: Internal.SpellList_, baseStack: Internal.List_<Internal.Iota>, acc: Internal.List_<Internal.Iota>)
        getType(): Internal.ContinuationFrame$Type<any>;
        getBaseStack(): Internal.List<Internal.Iota>;
        serializeToNBT(): Internal.CompoundTag;
        static copy$default(arg0: Internal.FrameForEach_, arg1: Internal.SpellList_, arg2: Internal.SpellList_, arg3: Internal.List_<any>, arg4: Internal.List_<any>, arg5: number, arg6: any): Internal.FrameForEach;
        static toNBT(frame: Internal.ContinuationFrame_): Internal.CompoundTag;
        evaluate(continuation: Internal.SpellContinuation_, level: Internal.ServerLevel_, harness: Internal.CastingVM_): Internal.CastResult;
        copy(data: Internal.SpellList_, code: Internal.SpellList_, baseStack: Internal.List_<Internal.Iota>, acc: Internal.List_<Internal.Iota>): this;
        component3(): Internal.List<Internal.Iota>;
        component4(): Internal.List<Internal.Iota>;
        getData(): Internal.SpellList;
        static fromNBT(tag: Internal.CompoundTag_, world: Internal.ServerLevel_): Internal.ContinuationFrame;
        size(): number;
        component1(): Internal.SpellList;
        component2(): Internal.SpellList;
        getAcc(): Internal.List<Internal.Iota>;
        getCode(): Internal.SpellList;
        breakDownwards(stack: Internal.List_<Internal.Iota>): kotlin.Pair<boolean, Internal.List<Internal.Iota>>;
        get type(): Internal.ContinuationFrame$Type<any>
        get baseStack(): Internal.List<Internal.Iota>
        get data(): Internal.SpellList
        get acc(): Internal.List<Internal.Iota>
        get code(): Internal.SpellList
        static readonly Companion: Internal.FrameForEach$Companion;
        static readonly TYPE: Internal.FrameForEach$Companion$TYPE$1;
    }
    type FrameForEach_ = FrameForEach;
    class SpeedControllerBlockEntity extends Internal.KineticBlockEntity implements Internal.ISpeedControllerAdapter {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        static getDesiredOutputSpeed(cogWheel: Internal.KineticBlockEntity_, speedControllerIn: Internal.KineticBlockEntity_, targetingController: boolean): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setTargetSpeed(speed: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        static getConveyedSpeed(cogWheel: Internal.KineticBlockEntity_, speedControllerIn: Internal.KineticBlockEntity_, targetingController: boolean): number;
        updateBracket(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getTargetSpeed(): number;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        set targetSpeed(speed: number)
        get infiniteBoundingBox(): Internal.AABB
        get targetSpeed(): number
        get renderBoundingBox(): Internal.AABB
        targetSpeed: Internal.ScrollValueBehaviour;
        static readonly DEFAULT_SPEED: 16;
        computerBehaviour: Internal.AbstractComputerBehaviour;
    }
    type SpeedControllerBlockEntity_ = SpeedControllerBlockEntity;
    class IRenderedBatteryUpgrade$BatteryRenderInfo {
        constructor(chargeRatio: number)
        getChargeRatio(): number;
        serialize(): Internal.CompoundTag;
        setChargeRatio(chargeRatio: number): void;
        static deserialize(tag: Internal.CompoundTag_): Internal.IRenderedBatteryUpgrade$BatteryRenderInfo;
        get chargeRatio(): number
        set chargeRatio(chargeRatio: number)
    }
    type IRenderedBatteryUpgrade$BatteryRenderInfo_ = IRenderedBatteryUpgrade$BatteryRenderInfo;
    class ScorchedAnvilBlock extends Internal.TinkerStationBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_, slotCount: number)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type ScorchedAnvilBlock_ = ScorchedAnvilBlock;
    class AlternativesEntry$Builder extends Internal.LootPoolEntryContainer$Builder<Internal.AlternativesEntry$Builder> {
        constructor(...$$0: Internal.LootPoolEntryContainer$Builder_<any>[])
        when<E>($$0: Internal.Iterable_<E>, $$1: Internal.Function_<E, Internal.LootItemCondition$Builder>): this;
    }
    type AlternativesEntry$Builder_ = AlternativesEntry$Builder;
    interface BlockableEventLoopAccessor {
        abstract callSubmitAsync(arg0: Internal.Runnable_): Internal.CompletableFuture<void>;
        (arg0: Internal.Runnable): Internal.CompletableFuture_<void>;
    }
    type BlockableEventLoopAccessor_ = BlockableEventLoopAccessor;
    class ItemSirenFlute extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemSirenFlute_ = ItemSirenFlute;
    class WorldDownload extends Internal.ValueObject {
        constructor()
        static parse($$0: string): Internal.WorldDownload;
        downloadLink: string;
        resourcePackUrl: string;
        resourcePackHash: string;
    }
    type WorldDownload_ = WorldDownload;
    class ModifierCrystalItem extends Internal.Item {
        constructor(props: Internal.Item$Properties_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static withModifier(modifier: Internal.ModifierId_): Internal.ItemStack;
        static getModifier(stack: Internal.ItemStack_): Internal.ModifierId;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        fillItemCategory(items: Internal.FabricItemGroupEntries_): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ModifierCrystalItem_ = ModifierCrystalItem;
    class LecternControllerBlockEntity extends Internal.SmartBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        isUsedBy(player: Internal.Player_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        static playerInRange(player: Internal.Player_, world: Internal.Level_, pos: BlockPos_): boolean;
        static playerIsUsingLectern(player: Internal.Player_): boolean;
        dropController(state: Internal.BlockState_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        tryStartUsing(player: Internal.Player_): void;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        tryStopUsing(player: Internal.Player_): void;
        getController(): Internal.ItemStack;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        setController(newController: Internal.ItemStack_): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        swapControllers(stack: Internal.ItemStack_, player: Internal.Player_, hand: Internal.InteractionHand_, state: Internal.BlockState_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        hasUser(): boolean;
        get controller(): Internal.ItemStack
        get infiniteBoundingBox(): Internal.AABB
        set controller(newController: Internal.ItemStack_)
    }
    type LecternControllerBlockEntity_ = LecternControllerBlockEntity;
    class FrameEvaluate implements Internal.ContinuationFrame {
        constructor(list: Internal.SpellList_, isMetacasting: boolean)
        getType(): Internal.ContinuationFrame$Type<any>;
        component2(): boolean;
        serializeToNBT(): Internal.CompoundTag;
        static copy$default(arg0: Internal.FrameEvaluate_, arg1: Internal.SpellList_, arg2: boolean, arg3: number, arg4: any): Internal.FrameEvaluate;
        static toNBT(frame: Internal.ContinuationFrame_): Internal.CompoundTag;
        evaluate(continuation: Internal.SpellContinuation_, level: Internal.ServerLevel_, harness: Internal.CastingVM_): Internal.CastResult;
        isMetacasting(): boolean;
        copy(list: Internal.SpellList_, isMetacasting: boolean): this;
        static fromNBT(tag: Internal.CompoundTag_, world: Internal.ServerLevel_): Internal.ContinuationFrame;
        size(): number;
        component1(): Internal.SpellList;
        getList(): Internal.SpellList;
        breakDownwards(stack: Internal.List_<Internal.Iota>): kotlin.Pair<boolean, Internal.List<Internal.Iota>>;
        get type(): Internal.ContinuationFrame$Type<any>
        get metacasting(): boolean
        get list(): Internal.SpellList
        static readonly TYPE: Internal.FrameEvaluate$Companion$TYPE$1;
        static readonly Companion: Internal.FrameEvaluate$Companion;
    }
    type FrameEvaluate_ = FrameEvaluate;
    class SmeltingRecipe extends Internal.AbstractCookingRecipe {
        constructor($$0: ResourceLocation_, $$1: string, $$2: Internal.CookingBookCategory_, $$3: Internal.Ingredient_, $$4: Internal.ItemStack_, $$5: number, $$6: number)
        isSpecial(): boolean;
        getGroup(): string;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        get special(): boolean
        get group(): string
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type SmeltingRecipe_ = SmeltingRecipe;
    class BlockHitResult extends Internal.HitResult {
        constructor($$0: Vec3d_, $$1: Internal.Direction_, $$2: BlockPos_, $$3: boolean)
        getBlockPos(): BlockPos;
        withPosition($$0: BlockPos_): this;
        withDirection($$0: Internal.Direction_): this;
        static miss($$0: Vec3d_, $$1: Internal.Direction_, $$2: BlockPos_): Internal.BlockHitResult;
        isInside(): boolean;
        getDirection(): Internal.Direction;
        get blockPos(): BlockPos
        get inside(): boolean
        get direction(): Internal.Direction
    }
    type BlockHitResult_ = BlockHitResult;
    interface MinecraftClientKJS extends Internal.MinecraftEnvironmentKJS {
        getDisplayName(): net.minecraft.network.chat.Component;
        setCurrentScreen(gui: Internal.Screen_): void;
        scheduleInTicks(ticks: number, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        isShiftDown(): boolean;
        getName(): net.minecraft.network.chat.Component;
        runCommandSilent(command: string): number;
        scheduleRepeatingInTicks(ticks: number, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        getCurrentWorldName(): string;
        isCtrlDown(): boolean;
        abstract getScheduledEvents(): Internal.ScheduledEvents;
        getCurrentScreen(): Internal.Screen;
        tell(message: net.minecraft.network.chat.Component_): void;
        self(): Internal.Minecraft;
        schedule(timer: Internal.TemporalAmount_, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        isAltDown(): boolean;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        scheduleRepeating(timer: Internal.TemporalAmount_, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        setTitle(t: string): void;
        isKeyDown(key: number): boolean;
        runCommand(command: string): number;
        get displayName(): net.minecraft.network.chat.Component
        set currentScreen(gui: Internal.Screen_)
        get shiftDown(): boolean
        get name(): net.minecraft.network.chat.Component
        get currentWorldName(): string
        get ctrlDown(): boolean
        get scheduledEvents(): Internal.ScheduledEvents
        get currentScreen(): Internal.Screen
        get altDown(): boolean
        set statusMessage(message: net.minecraft.network.chat.Component_)
        set title(t: string)
        (): Internal.ScheduledEvents_;
    }
    type MinecraftClientKJS_ = MinecraftClientKJS;
    class Timer {
        constructor($$0: number, $$1: number)
        advanceTime($$0: number): number;
        tickDelta: number;
        partialTick: number;
        msPerTick: number;
    }
    type Timer_ = Timer;
    abstract class ContainerFillingRecipe implements Internal.IMultiRecipe<Internal.DisplayCastingRecipe>, Internal.ICastingRecipe {
        constructor(type: Internal.RecipeType_<any>, id: ResourceLocation_, group: string, fluidAmount: number, container: Internal.Item_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        assemble(inv: Internal.ICastingContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        getContainer(): Internal.Item;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getRemainingItems($$0: Internal.ICastingContainer_): Internal.NonNullList<Internal.ItemStack>;
        matches(inv: Internal.ICastingContainer_, worldIn: Internal.Level_): boolean;
        getCoolingTime(inv: Internal.ICastingContainer_): number;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        isConsumed(): boolean;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getFluidAmount(inv: Internal.ICastingContainer_): number;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getFluidAmount(): number;
        switchSlots(): boolean;
        getOrCreateId(): ResourceLocation;
        static calcCoolingTime(fluid: Internal.FluidStack_): number;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        getRecipes(): Internal.List<Internal.DisplayCastingRecipe>;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        static calcCoolingTime(temperature: number, amount: number): number;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get container(): Internal.Item
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get consumed(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get fluidAmount(): number
        get orCreateId(): ResourceLocation
        get recipes(): Internal.List<Internal.DisplayCastingRecipe>
        get incomplete(): boolean
    }
    type ContainerFillingRecipe_ = ContainerFillingRecipe;
    interface ResourceOrTagKeyArgument$Result <T> extends Internal.Predicate<Internal.Holder<T>> {
        not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        abstract test(arg0: Internal.Holder_<T>): boolean;
        negate(): Internal.Predicate<Internal.Holder<T>>;
        abstract asPrintable(): string;
        abstract cast<E>(arg0: Internal.ResourceKey_<Internal.Registry<E>>): Internal.Optional<Internal.ResourceOrTagKeyArgument$Result<E>>;
        or(arg0: Internal.Predicate_<Internal.Holder<T>>): Internal.Predicate<Internal.Holder<T>>;
        and(arg0: Internal.Predicate_<Internal.Holder<T>>): Internal.Predicate<Internal.Holder<T>>;
        abstract unwrap(): Internal.Either<Internal.ResourceKey<T>, Internal.TagKey<T>>;
        isEqual<T>(arg0: any): Internal.Predicate<T>;
    }
    type ResourceOrTagKeyArgument$Result_<T> = ResourceOrTagKeyArgument$Result<T>;
    interface ModMetadata {
        abstract getEnvironment(): Internal.ModEnvironment;
        /**
         * @deprecated
        */
        getSuggests(): Internal.Collection<Internal.ModDependency>;
        /**
         * @deprecated
        */
        getDepends(): Internal.Collection<Internal.ModDependency>;
        abstract getCustomValues(): Internal.Map<string, Internal.CustomValue>;
        abstract getCustomValue(arg0: string): Internal.CustomValue;
        abstract getDescription(): string;
        abstract getAuthors(): Internal.Collection<Internal.Person>;
        abstract getId(): string;
        abstract getIconPath(arg0: number): Internal.Optional<string>;
        /**
         * @deprecated
        */
        getRecommends(): Internal.Collection<Internal.ModDependency>;
        /**
         * @deprecated
        */
        getBreaks(): Internal.Collection<Internal.ModDependency>;
        /**
         * @deprecated
        */
        getConflicts(): Internal.Collection<Internal.ModDependency>;
        /**
         * @deprecated
        */
        abstract containsCustomElement(arg0: string): boolean;
        abstract getLicense(): Internal.Collection<string>;
        abstract getVersion(): Internal.Version;
        abstract containsCustomValue(arg0: string): boolean;
        abstract getName(): string;
        abstract getType(): string;
        abstract getDependencies(): Internal.Collection<Internal.ModDependency>;
        abstract getProvides(): Internal.Collection<string>;
        abstract getContributors(): Internal.Collection<Internal.Person>;
        abstract getContact(): Internal.ContactInformation;
        get environment(): Internal.ModEnvironment
        /**
         * @deprecated
        */
        get suggests(): Internal.Collection<Internal.ModDependency>
        /**
         * @deprecated
        */
        get depends(): Internal.Collection<Internal.ModDependency>
        get customValues(): Internal.Map<string, Internal.CustomValue>
        get description(): string
        get authors(): Internal.Collection<Internal.Person>
        get id(): string
        /**
         * @deprecated
        */
        get recommends(): Internal.Collection<Internal.ModDependency>
        /**
         * @deprecated
        */
        get breaks(): Internal.Collection<Internal.ModDependency>
        /**
         * @deprecated
        */
        get conflicts(): Internal.Collection<Internal.ModDependency>
        get license(): Internal.Collection<string>
        get version(): Internal.Version
        get name(): string
        get type(): string
        get dependencies(): Internal.Collection<Internal.ModDependency>
        get provides(): Internal.Collection<string>
        get contributors(): Internal.Collection<Internal.Person>
        get contact(): Internal.ContactInformation
    }
    type ModMetadata_ = ModMetadata;
    class GossipContainer {
        constructor()
        getGossipEntries(): Internal.Map<Internal.UUID, Internal.Object2IntMap<Internal.GossipType>>;
        remove($$0: Internal.UUID_, $$1: Internal.GossipType_, $$2: number): void;
        getCountForType($$0: Internal.GossipType_, $$1: Internal.DoublePredicate_): number;
        remove($$0: Internal.UUID_, $$1: Internal.GossipType_): void;
        add($$0: Internal.UUID_, $$1: Internal.GossipType_, $$2: number): void;
        decay(): void;
        update($$0: Internal.Dynamic_<any>): void;
        store<T>($$0: Internal.DynamicOps_<T>): T;
        transferFrom($$0: Internal.GossipContainer_, $$1: Internal.RandomSource_, $$2: number): void;
        remove($$0: Internal.GossipType_): void;
        getReputation($$0: Internal.UUID_, $$1: Internal.Predicate_<Internal.GossipType>): number;
        get gossipEntries(): Internal.Map<Internal.UUID, Internal.Object2IntMap<Internal.GossipType>>
        static readonly DISCARD_THRESHOLD: 2;
    }
    type GossipContainer_ = GossipContainer;
    class RenderInfo$ItemDisplayRenderInfo {
        constructor()
        getDisplayItem(): Internal.Optional<Internal.RenderInfo$DisplayItem>;
        serialize(): Internal.CompoundTag;
        static deserialize(tag: Internal.CompoundTag_): Internal.RenderInfo$ItemDisplayRenderInfo;
        getDisplayItems(): Internal.List<Internal.RenderInfo$DisplayItem>;
        getInaccessibleSlots(): Internal.List<number>;
        getSlotCounts(): Internal.List<number>;
        getSlotFillRatios(): Internal.List<number>;
        getInfiniteSlots(): Internal.List<number>;
        get displayItem(): Internal.Optional<Internal.RenderInfo$DisplayItem>
        get displayItems(): Internal.List<Internal.RenderInfo$DisplayItem>
        get inaccessibleSlots(): Internal.List<number>
        get slotCounts(): Internal.List<number>
        get slotFillRatios(): Internal.List<number>
        get infiniteSlots(): Internal.List<number>
        static readonly SLOT_COUNTS_TAG: "slotCounts";
        static readonly SLOT_FILL_RATIOS_TAG: "slotFillRatios";
    }
    type RenderInfo$ItemDisplayRenderInfo_ = RenderInfo$ItemDisplayRenderInfo;
    class AllArmInteractionPointTypes$DeployerType extends Internal.ArmInteractionPointType {
        constructor()
    }
    type AllArmInteractionPointTypes$DeployerType_ = AllArmInteractionPointTypes$DeployerType;
    interface CustomHitParticleItem {
        abstract spawnHitParticles(arg0: Internal.Player_): void;
        (arg0: Internal.Player): void;
    }
    type CustomHitParticleItem_ = CustomHitParticleItem;
    class RedstoneRequesterBlock extends Internal.Block implements Internal.WeakPowerCheckingBlock, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.RedstoneRequesterBlockEntity> {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        static appendRequesterTooltip(pStack: Internal.ItemStack_, pTooltip: Internal.List_<net.minecraft.network.chat.Component>): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.RedstoneRequesterBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.RedstoneRequesterBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.RedstoneRequesterBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        shouldCheckWeakPower(state: Internal.BlockState_, level: Internal.SignalGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityClass(): typeof Internal.RedstoneRequesterBlockEntity;
        static programRequester(player: Internal.ServerPlayer_, be: Internal.StockTickerBlockEntity_, order: Internal.PackageOrderWithCrafts_, address: string): void;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.RedstoneRequesterBlockEntity;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.RedstoneRequesterBlockEntity>): void;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.RedstoneRequesterBlockEntity>
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.RedstoneRequesterBlockEntity
        static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type RedstoneRequesterBlock_ = RedstoneRequesterBlock;
    interface IGridNodeService {
    }
    type IGridNodeService_ = IGridNodeService;
    class ClientboundRemoveMobEffectPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: Internal.MobEffect_)
        handle(arg0: Internal.PacketListener_): void;
        getEffect(): Internal.MobEffect;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getEntity($$0: Internal.Level_): Internal.Entity;
        isSkippable(): boolean;
        get effect(): Internal.MobEffect
        get skippable(): boolean
    }
    type ClientboundRemoveMobEffectPacket_ = ClientboundRemoveMobEffectPacket;
    interface IScheduleInput {
        abstract getId(): ResourceLocation;
        abstract setData(arg0: Internal.CompoundTag_): void;
        getItem(slot: number): Internal.ItemStack;
        slotsTargeted(): number;
        abstract getData(): Internal.CompoundTag;
        getSecondLineTooltip(slot: number): Internal.List<net.minecraft.network.chat.Component>;
        setItem(slot: number, stack: Internal.ItemStack_): void;
        abstract getSummary(): net.createmod.catnip.data.Pair<Internal.ItemStack, net.minecraft.network.chat.Component>;
        getSecondLineIcon(): Internal.ItemStack;
        getTitleAs(type: string): Internal.List<net.minecraft.network.chat.Component>;
        renderSpecialIcon(graphics: Internal.GuiGraphics_, x: number, y: number): boolean;
        initConfigurationWidgets(builder: Internal.ModularGuiLineBuilder_): void;
        get id(): ResourceLocation
        set data(arg0: Internal.CompoundTag_)
        get data(): Internal.CompoundTag
        get summary(): net.createmod.catnip.data.Pair<Internal.ItemStack, net.minecraft.network.chat.Component>
        get secondLineIcon(): Internal.ItemStack
    }
    type IScheduleInput_ = IScheduleInput;
    class DigitalAdapterBlockItem extends Internal.BlockItem {
        constructor(block: Internal.Block_, props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DigitalAdapterBlockItem_ = DigitalAdapterBlockItem;
    interface MixinWorldProperties extends Internal.ComponentProvider {
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        abstract getComponentContainer(): Internal.ComponentContainer;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        get componentContainer(): Internal.ComponentContainer
        (): Internal.ComponentContainer_;
    }
    type MixinWorldProperties_ = MixinWorldProperties;
    interface ToolActionItem {
        canPerformAction(stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): boolean;
    }
    type ToolActionItem_ = ToolActionItem;
    interface ScheduledEvents$Callback {
        abstract onCallback(arg0: Internal.ScheduledEvents$ScheduledEvent_): void;
        (arg0: Internal.ScheduledEvents$ScheduledEvent): void;
    }
    type ScheduledEvents$Callback_ = ScheduledEvents$Callback;
    abstract class MaterialCastingRecipe extends Internal.AbstractCastingRecipe implements Internal.IMultiRecipe<Internal.IDisplayableCastingRecipe> {
        constructor(type: Internal.RecipeType_<any>, id: ResourceLocation_, group: string, cast: Internal.Ingredient_, itemCost: number, result: Internal.IMaterialItem_, consumed: boolean, switchSlots: boolean)
        isSpecial(): boolean;
        getRemainingItems($$0: Internal.ICastingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getGroup(): string;
        matches(inv: Internal.ICastingContainer_, worldIn: Internal.Level_): boolean;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        assemble(inv: Internal.ICastingContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        static calcCoolingTime(fluid: Internal.FluidStack_): number;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        static calcCoolingTime(temperature: number, amount: number): number;
        getMod(): string;
        getRecipes(): Internal.List<Internal.IDisplayableCastingRecipe>;
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
        get recipes(): Internal.List<Internal.IDisplayableCastingRecipe>
    }
    type MaterialCastingRecipe_ = MaterialCastingRecipe;
    class BatteryUpgradeItem extends Internal.UpgradeItemBase<Internal.BatteryUpgradeWrapper> {
        constructor(batteryUpgradeConfig: Internal.BatteryUpgradeConfig_, upgradeTypeLimitConfig: any_)
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getAdjustedStackMultiplier(storageWrapper: Internal.IStorageWrapper_): number;
        setDigSpeed(speed: number): void;
        getMaxEnergyStored(storageWrapper: Internal.IStorageWrapper_): number;
        getMaxEnergyBase(storageWrapper: Internal.IStorageWrapper_): number;
        getBatteryUpgradeConfig(): Internal.BatteryUpgradeConfig;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        getType(): Internal.UpgradeType<Internal.BatteryUpgradeWrapper>;
        set digSpeed(speed: number)
        get batteryUpgradeConfig(): Internal.BatteryUpgradeConfig
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get type(): Internal.UpgradeType<Internal.BatteryUpgradeWrapper>
        static readonly UPGRADE_CONFLICT_DEFINITIONS: [Internal.IUpgradeItem$UpgradeConflictDefinition];
        static readonly TYPE: Internal.UpgradeType<Internal.BatteryUpgradeWrapper>;
    }
    type BatteryUpgradeItem_ = BatteryUpgradeItem;
    class ItemDragonArrow extends Internal.ArrowItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemDragonArrow_ = ItemDragonArrow;
    class Display$BillboardConstraints extends Internal.Enum<Internal.Display$BillboardConstraints> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf($$0: string): Internal.Display$BillboardConstraints;
        getSerializedName(): string;
        static values(): Internal.Display$BillboardConstraints[];
        get serializedName(): string
        static readonly VERTICAL: Internal.Display$BillboardConstraints;
        static readonly HORIZONTAL: Internal.Display$BillboardConstraints;
        static readonly CODEC: Internal.Codec<Internal.Display$BillboardConstraints>;
        static readonly BY_ID: Internal.IntFunction<Internal.Display$BillboardConstraints>;
        static readonly FIXED: Internal.Display$BillboardConstraints;
        static readonly CENTER: Internal.Display$BillboardConstraints;
    }
    type Display$BillboardConstraints_ = Display$BillboardConstraints | "fixed" | "center" | "vertical" | "horizontal";
    class BlockWirelessConnector extends Internal.BlockBaseGui<Internal.TileWirelessConnector> {
        constructor()
        openGui(tile: Internal.TileWirelessConnector_, p: Internal.Player_): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        check(tile: Internal.TileWirelessConnector_, stack: Internal.ItemStack_, world: Internal.Level_, thisPos: BlockPos_, hit: Internal.BlockHitResult_, p: Internal.Player_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockWirelessConnector_ = BlockWirelessConnector;
    class ChatReportBuilder$ChatReport {
        toggleReported($$0: number, $$1: Internal.AbuseReportLimits_): void;
        copy(): this;
        isReportedPlayer($$0: Internal.UUID_): boolean;
    }
    type ChatReportBuilder$ChatReport_ = ChatReportBuilder$ChatReport;
    class BlockTooltipItem extends Internal.BlockItem {
        constructor(blockIn: Internal.Block_, builder: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BlockTooltipItem_ = BlockTooltipItem;
    class ItemModArmor extends Internal.ArmorItem implements Internal.IArmorTextureProvider {
        constructor(material: Internal.ArmorMaterial_, slot: Internal.ArmorItem$Type_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        getArmorTexture(stack: Internal.ItemStack_, entity: Internal.Entity_, slot: Internal.EquipmentSlot_, type: string): ResourceLocation;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemModArmor_ = ItemModArmor;
    class HeightmapPlacement extends Internal.PlacementModifier {
        static onHeightmap($$0: Internal.Heightmap$Types_): Internal.HeightmapPlacement;
        static readonly CODEC: Internal.Codec<Internal.HeightmapPlacement>;
    }
    type HeightmapPlacement_ = HeightmapPlacement;
    class NarrowTrackBufferBlock$Style extends Internal.Enum<Internal.NarrowTrackBufferBlock$Style> implements Internal.StringRepresentable {
        static values(): Internal.NarrowTrackBufferBlock$Style[];
        getModel(): ResourceLocation;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.NarrowTrackBufferBlock$Style;
        get model(): ResourceLocation
        get serializedName(): string
        static readonly STANDARD: Internal.NarrowTrackBufferBlock$Style;
        static readonly MONO: Internal.NarrowTrackBufferBlock$Style;
    }
    type NarrowTrackBufferBlock$Style_ = NarrowTrackBufferBlock$Style | "standard" | "mono";
    class SlimesuitItem extends Internal.ModifiableArmorItem implements Internal.ArmorTextureItem {
        constructor(material: any_, slotType: any_, properties: Internal.Item$Properties_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        static makeArmorTexture(material: string, texture: string): string;
        static getMaterial(stack: Internal.ItemStack_): string;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLocalizedName(): net.minecraft.network.chat.Component;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        doVanillaElytraTick(entity: Internal.LivingEntity_, chestStack: Internal.ItemStack_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getArmorTexture(stack: Internal.ItemStack_, entity: Internal.Entity_, slot: Internal.EquipmentSlot_, type: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get localizedName(): net.minecraft.network.chat.Component
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SlimesuitItem_ = SlimesuitItem;
    class AccessRestriction extends Internal.Enum<Internal.AccessRestriction> {
        static values(): Internal.AccessRestriction[];
        isAllowInsertion(): boolean;
        isAllowExtraction(): boolean;
        static valueOf(name: string): Internal.AccessRestriction;
        get allowInsertion(): boolean
        get allowExtraction(): boolean
        static readonly NO_ACCESS: Internal.AccessRestriction;
        static readonly WRITE: Internal.AccessRestriction;
        static readonly READ: Internal.AccessRestriction;
        static readonly READ_WRITE: Internal.AccessRestriction;
    }
    type AccessRestriction_ = "read" | AccessRestriction | "write" | "no_access" | "read_write";
    class CookingLogic <T extends Internal.AbstractCookingRecipe> {
        constructor(upgrade: Internal.ItemStack_, saveHandler: Internal.Consumer_<Internal.ItemStack>, isFuel: Internal.Predicate_<Internal.ItemStack>, isInput: Internal.Predicate_<Internal.ItemStack>, cookingUpgradeConfig: Internal.CookingUpgradeConfig_, recipeType: Internal.RecipeType_<T>, burnTimeModifier: number)
        constructor(upgrade: Internal.ItemStack_, saveHandler: Internal.Consumer_<Internal.ItemStack>, cookingUpgradeConfig: Internal.CookingUpgradeConfig_, recipeType: Internal.RecipeType_<T>, burnTimeModifier: number)
        setFuel(fuel: Internal.ItemStack_): void;
        isCooking(): boolean;
        getCookTimeFinish(): number;
        getCookTimeTotal(): number;
        getFuel(): Internal.ItemStack;
        getBurnTimeTotal(): number;
        isBurning(world: Internal.Level_): boolean;
        getCookInput(): Internal.ItemStack;
        getBurnTimeFinish(): number;
        setCookInput(input: Internal.ItemStack_): void;
        pause(): void;
        getCookOutput(): Internal.ItemStack;
        getCookingInventory(): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
        tick(level: Internal.Level_): boolean;
        set fuel(fuel: Internal.ItemStack_)
        get cooking(): boolean
        get cookTimeFinish(): number
        get cookTimeTotal(): number
        get fuel(): Internal.ItemStack
        get burnTimeTotal(): number
        get cookInput(): Internal.ItemStack
        get burnTimeFinish(): number
        set cookInput(input: Internal.ItemStack_)
        get cookOutput(): Internal.ItemStack
        get cookingInventory(): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler
        static readonly FUEL_SLOT: 1;
        static readonly COOK_INPUT_SLOT: 0;
        static readonly COOK_OUTPUT_SLOT: 2;
    }
    type CookingLogic_<T extends Internal.AbstractCookingRecipe> = CookingLogic<T>;
    abstract class AbstractModifierRecipe implements Internal.IDisplayModifierRecipe, Internal.ITinkerStationRecipe {
        getGroup(): string;
        abstract getValidatedResult(arg0: Internal.ITinkerStationContainer_, arg1: Internal.RegistryAccess_): Internal.ValidatedResult;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        getRemainingItems(inv: Internal.ITinkerStationContainer_): Internal.NonNullList<Internal.ItemStack>;
        abstract getDisplayItems(arg0: number): Internal.List<Internal.ItemStack>;
        abstract matches(arg0: Internal.ITinkerStationContainer_, arg1: Internal.Level_): boolean;
        static matchesCrystal(container: Internal.ITinkerStationContainer_, match: Internal.ModifierEntry_): boolean;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        updateInputs(result: Internal.ItemStack_, inv: Internal.IMutableTinkerStationContainer_, isServer: boolean): void;
        getToolWithoutModifier(): Internal.List<Internal.ItemStack>;
        getSlots(): Internal.SlotType$SlotCount;
        getSlotType(): Internal.SlotType;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        isIncremental(): boolean;
        getToolWithModifier(): Internal.List<Internal.ItemStack>;
        getMod(): string;
        static withModifiers(stack: Internal.ItemStack_, match: Internal.ModifierMatch_, newModifier: Internal.ModifierEntry_): Internal.ItemStack;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getDisplayResult(): Internal.ModifierEntry;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(access: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<any>;
        getMaxLevel(): number;
        shrinkToolSlotBy(): number;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        assemble(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        abstract getInputCount(): number;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        static withModifiers(stack: Internal.ItemStack_, match: Internal.ModifierMatch_, newModifier: Internal.ModifierEntry_, persistentDataConsumer: Internal.Consumer_<Internal.ModDataNBT>): Internal.ItemStack;
        isIncomplete(): boolean;
        getRequirementsError(): string;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        static getModifiersIgnoringPartial(toolStack: Internal.ToolStack_): Internal.List<Internal.ModifierEntry>;
        hasRequirements(): boolean;
        getModifier(): Internal.Modifier;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get toolWithoutModifier(): Internal.List<Internal.ItemStack>
        get slots(): Internal.SlotType$SlotCount
        get slotType(): Internal.SlotType
        get incremental(): boolean
        get toolWithModifier(): Internal.List<Internal.ItemStack>
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get displayResult(): Internal.ModifierEntry
        get maxLevel(): number
        get type(): ResourceLocation
        get inputCount(): number
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get requirementsError(): string
        get modifier(): Internal.Modifier
    }
    type AbstractModifierRecipe_ = AbstractModifierRecipe;
    interface NeighborChangeListeningBlock {
        abstract onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        (arg0: Internal.BlockState, arg1: Internal.LevelReader, arg2: BlockPos, arg3: BlockPos): void;
    }
    type NeighborChangeListeningBlock_ = NeighborChangeListeningBlock;
    class TelemetryProperty$GameMode extends Internal.Enum<Internal.TelemetryProperty$GameMode> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        id(): number;
        getSerializedName(): string;
        static values(): Internal.TelemetryProperty$GameMode[];
        static valueOf($$0: string): Internal.TelemetryProperty$GameMode;
        get serializedName(): string
        static readonly SURVIVAL: Internal.TelemetryProperty$GameMode;
        static readonly CODEC: Internal.Codec<Internal.TelemetryProperty$GameMode>;
        static readonly HARDCORE: Internal.TelemetryProperty$GameMode;
        static readonly CREATIVE: Internal.TelemetryProperty$GameMode;
        static readonly ADVENTURE: Internal.TelemetryProperty$GameMode;
        static readonly SPECTATOR: Internal.TelemetryProperty$GameMode;
    }
    type TelemetryProperty$GameMode_ = "hardcore" | "spectator" | "adventure" | "survival" | TelemetryProperty$GameMode | "creative";
    class BlockCharedPath extends Internal.DirtPathBlock {
        constructor(dragonType: number)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMetaFromState(state: Internal.BlockState_): number;
        getMod(): string;
        getSmushedState(dragonType: number): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getStateFromMeta(meta: number): Internal.BlockState;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static getNameFromType(dragonType: number): string;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly REVERTS: Internal.BooleanProperty;
        readonly dragonType: number;
    }
    type BlockCharedPath_ = BlockCharedPath;
    interface OutgoingChatMessage {
        abstract content(): net.minecraft.network.chat.Component;
        create($$0: Internal.PlayerChatMessage_): this;
        abstract sendToPlayer(arg0: Internal.ServerPlayer_, arg1: boolean, arg2: Internal.ChatType$Bound_): void;
    }
    type OutgoingChatMessage_ = OutgoingChatMessage;
    class ClientboundClearTitlesPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: boolean)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        shouldResetTimes(): boolean;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundClearTitlesPacket_ = ClientboundClearTitlesPacket;
    interface SelectableResource <T> {
        item(stack: Internal.ItemStack_): Internal.SelectableResource<Internal.ItemStack>;
        abstract setTag(arg0: Internal.CompoundTag_): void;
        abstract getName(): net.minecraft.network.chat.Component;
        abstract getIcon(): Internal.Icon;
        abstract getCount(): number;
        abstract copyWithCount(arg0: number): this;
        abstract getTag(): Internal.CompoundTag;
        isEmpty(): boolean;
        abstract setCount(arg0: number): void;
        abstract stack(): T;
        fluid(stack: dev.architectury.fluid.FluidStack_): Internal.SelectableResource<dev.architectury.fluid.FluidStack>;
        set tag(arg0: Internal.CompoundTag_)
        get name(): net.minecraft.network.chat.Component
        get icon(): Internal.Icon
        get count(): number
        get tag(): Internal.CompoundTag
        get empty(): boolean
        set count(arg0: number)
    }
    type SelectableResource_<T> = SelectableResource<T>;
}
declare namespace com.mojang.authlib.properties {
    class Property {
        constructor(arg0: string, arg1: string, arg2: string)
        constructor(arg0: string, arg1: string)
        /**
         * @deprecated
        */
        isSignatureValid(arg0: Internal.PublicKey_): boolean;
        getValue(): string;
        getName(): string;
        getSignature(): string;
        hasSignature(): boolean;
        get value(): string
        get name(): string
        get signature(): string
    }
    type Property_ = Property;
}
declare namespace slimeknights.tconstruct.tables.block {
    class ChestBlock extends Internal.TabbedTableBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_, blockEntity: any_<Internal.BlockEntity>, dropsItems: boolean)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type ChestBlock_ = ChestBlock;
}
